/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.ContactRecordingType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SuspendContactRecordingRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, SuspendContactRecordingRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(SuspendContactRecordingRequest.getter(SuspendContactRecordingRequest::instanceId)).setter(SuspendContactRecordingRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactId").getter(SuspendContactRecordingRequest.getter(SuspendContactRecordingRequest::contactId)).setter(SuspendContactRecordingRequest.setter(Builder::contactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()}).build();
    private static final SdkField<String> INITIAL_CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitialContactId").getter(SuspendContactRecordingRequest.getter(SuspendContactRecordingRequest::initialContactId)).setter(SuspendContactRecordingRequest.setter(Builder::initialContactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialContactId").build()}).build();
    private static final SdkField<String> CONTACT_RECORDING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactRecordingType").getter(SuspendContactRecordingRequest.getter(SuspendContactRecordingRequest::contactRecordingTypeAsString)).setter(SuspendContactRecordingRequest.setter(Builder::contactRecordingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactRecordingType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, CONTACT_ID_FIELD, INITIAL_CONTACT_ID_FIELD, CONTACT_RECORDING_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SuspendContactRecordingRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String contactId;
    private final String initialContactId;
    private final String contactRecordingType;

    private SuspendContactRecordingRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.contactId = builder.contactId;
        this.initialContactId = builder.initialContactId;
        this.contactRecordingType = builder.contactRecordingType;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String contactId() {
        return this.contactId;
    }

    public final String initialContactId() {
        return this.initialContactId;
    }

    public final ContactRecordingType contactRecordingType() {
        return ContactRecordingType.fromValue(this.contactRecordingType);
    }

    public final String contactRecordingTypeAsString() {
        return this.contactRecordingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialContactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactRecordingTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuspendContactRecordingRequest)) {
            return false;
        }
        SuspendContactRecordingRequest other = (SuspendContactRecordingRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.contactId(), other.contactId()) && Objects.equals(this.initialContactId(), other.initialContactId()) && Objects.equals(this.contactRecordingTypeAsString(), other.contactRecordingTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SuspendContactRecordingRequest").add("InstanceId", (Object)this.instanceId()).add("ContactId", (Object)this.contactId()).add("InitialContactId", (Object)this.initialContactId()).add("ContactRecordingType", (Object)this.contactRecordingTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ContactId": {
                return Optional.ofNullable(clazz.cast(this.contactId()));
            }
            case "InitialContactId": {
                return Optional.ofNullable(clazz.cast(this.initialContactId()));
            }
            case "ContactRecordingType": {
                return Optional.ofNullable(clazz.cast(this.contactRecordingTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ContactId", CONTACT_ID_FIELD);
        map.put("InitialContactId", INITIAL_CONTACT_ID_FIELD);
        map.put("ContactRecordingType", CONTACT_RECORDING_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SuspendContactRecordingRequest, T> g) {
        return obj -> g.apply((SuspendContactRecordingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String contactId;
        private String initialContactId;
        private String contactRecordingType;

        private BuilderImpl() {
        }

        private BuilderImpl(SuspendContactRecordingRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.contactId(model.contactId);
            this.initialContactId(model.initialContactId);
            this.contactRecordingType(model.contactRecordingType);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getContactId() {
            return this.contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getInitialContactId() {
            return this.initialContactId;
        }

        public final void setInitialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
        }

        @Override
        public final Builder initialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
            return this;
        }

        public final String getContactRecordingType() {
            return this.contactRecordingType;
        }

        public final void setContactRecordingType(String contactRecordingType) {
            this.contactRecordingType = contactRecordingType;
        }

        @Override
        public final Builder contactRecordingType(String contactRecordingType) {
            this.contactRecordingType = contactRecordingType;
            return this;
        }

        @Override
        public final Builder contactRecordingType(ContactRecordingType contactRecordingType) {
            this.contactRecordingType(contactRecordingType == null ? null : contactRecordingType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SuspendContactRecordingRequest build() {
            return new SuspendContactRecordingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SuspendContactRecordingRequest> {
        public Builder instanceId(String var1);

        public Builder contactId(String var1);

        public Builder initialContactId(String var1);

        public Builder contactRecordingType(String var1);

        public Builder contactRecordingType(ContactRecordingType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

