/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ParticipantState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StateTransition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StateTransition> {
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(StateTransition.getter(StateTransition::stateAsString)).setter(StateTransition.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> STATE_START_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StateStartTimestamp").getter(StateTransition.getter(StateTransition::stateStartTimestamp)).setter(StateTransition.setter(Builder::stateStartTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateStartTimestamp").build()}).build();
    private static final SdkField<Instant> STATE_END_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StateEndTimestamp").getter(StateTransition.getter(StateTransition::stateEndTimestamp)).setter(StateTransition.setter(Builder::stateEndTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateEndTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, STATE_START_TIMESTAMP_FIELD, STATE_END_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StateTransition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String state;
    private final Instant stateStartTimestamp;
    private final Instant stateEndTimestamp;

    private StateTransition(BuilderImpl builder) {
        this.state = builder.state;
        this.stateStartTimestamp = builder.stateStartTimestamp;
        this.stateEndTimestamp = builder.stateEndTimestamp;
    }

    public final ParticipantState state() {
        return ParticipantState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant stateStartTimestamp() {
        return this.stateStartTimestamp;
    }

    public final Instant stateEndTimestamp() {
        return this.stateEndTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateStartTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateEndTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StateTransition)) {
            return false;
        }
        StateTransition other = (StateTransition)obj;
        return Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateStartTimestamp(), other.stateStartTimestamp()) && Objects.equals(this.stateEndTimestamp(), other.stateEndTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"StateTransition").add("State", (Object)this.stateAsString()).add("StateStartTimestamp", (Object)this.stateStartTimestamp()).add("StateEndTimestamp", (Object)this.stateEndTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateStartTimestamp": {
                return Optional.ofNullable(clazz.cast(this.stateStartTimestamp()));
            }
            case "StateEndTimestamp": {
                return Optional.ofNullable(clazz.cast(this.stateEndTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("State", STATE_FIELD);
        map.put("StateStartTimestamp", STATE_START_TIMESTAMP_FIELD);
        map.put("StateEndTimestamp", STATE_END_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StateTransition, T> g) {
        return obj -> g.apply((StateTransition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private Instant stateStartTimestamp;
        private Instant stateEndTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(StateTransition model) {
            this.state(model.state);
            this.stateStartTimestamp(model.stateStartTimestamp);
            this.stateEndTimestamp(model.stateEndTimestamp);
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ParticipantState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getStateStartTimestamp() {
            return this.stateStartTimestamp;
        }

        public final void setStateStartTimestamp(Instant stateStartTimestamp) {
            this.stateStartTimestamp = stateStartTimestamp;
        }

        @Override
        public final Builder stateStartTimestamp(Instant stateStartTimestamp) {
            this.stateStartTimestamp = stateStartTimestamp;
            return this;
        }

        public final Instant getStateEndTimestamp() {
            return this.stateEndTimestamp;
        }

        public final void setStateEndTimestamp(Instant stateEndTimestamp) {
            this.stateEndTimestamp = stateEndTimestamp;
        }

        @Override
        public final Builder stateEndTimestamp(Instant stateEndTimestamp) {
            this.stateEndTimestamp = stateEndTimestamp;
            return this;
        }

        public StateTransition build() {
            return new StateTransition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StateTransition> {
        public Builder state(String var1);

        public Builder state(ParticipantState var1);

        public Builder stateStartTimestamp(Instant var1);

        public Builder stateEndTimestamp(Instant var1);
    }
}

