/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.OutboundCallerConfig;
import software.amazon.awssdk.services.connect.model.OutboundEmailConfig;
import software.amazon.awssdk.services.connect.model.QueueStatus;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Queue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Queue> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Queue.getter(Queue::name)).setter(Queue.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> QUEUE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueueArn").getter(Queue.getter(Queue::queueArn)).setter(Queue.setter(Builder::queueArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueArn").build()}).build();
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueueId").getter(Queue.getter(Queue::queueId)).setter(Queue.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Queue.getter(Queue::description)).setter(Queue.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<OutboundCallerConfig> OUTBOUND_CALLER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutboundCallerConfig").getter(Queue.getter(Queue::outboundCallerConfig)).setter(Queue.setter(Builder::outboundCallerConfig)).constructor(OutboundCallerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundCallerConfig").build()}).build();
    private static final SdkField<OutboundEmailConfig> OUTBOUND_EMAIL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutboundEmailConfig").getter(Queue.getter(Queue::outboundEmailConfig)).setter(Queue.setter(Builder::outboundEmailConfig)).constructor(OutboundEmailConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundEmailConfig").build()}).build();
    private static final SdkField<String> HOURS_OF_OPERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HoursOfOperationId").getter(Queue.getter(Queue::hoursOfOperationId)).setter(Queue.setter(Builder::hoursOfOperationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HoursOfOperationId").build()}).build();
    private static final SdkField<Integer> MAX_CONTACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxContacts").getter(Queue.getter(Queue::maxContacts)).setter(Queue.setter(Builder::maxContacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxContacts").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Queue.getter(Queue::statusAsString)).setter(Queue.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(Queue.getter(Queue::tags)).setter(Queue.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(Queue.getter(Queue::lastModifiedTime)).setter(Queue.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedRegion").getter(Queue.getter(Queue::lastModifiedRegion)).setter(Queue.setter(Builder::lastModifiedRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, QUEUE_ARN_FIELD, QUEUE_ID_FIELD, DESCRIPTION_FIELD, OUTBOUND_CALLER_CONFIG_FIELD, OUTBOUND_EMAIL_CONFIG_FIELD, HOURS_OF_OPERATION_ID_FIELD, MAX_CONTACTS_FIELD, STATUS_FIELD, TAGS_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Queue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String queueArn;
    private final String queueId;
    private final String description;
    private final OutboundCallerConfig outboundCallerConfig;
    private final OutboundEmailConfig outboundEmailConfig;
    private final String hoursOfOperationId;
    private final Integer maxContacts;
    private final String status;
    private final Map<String, String> tags;
    private final Instant lastModifiedTime;
    private final String lastModifiedRegion;

    private Queue(BuilderImpl builder) {
        this.name = builder.name;
        this.queueArn = builder.queueArn;
        this.queueId = builder.queueId;
        this.description = builder.description;
        this.outboundCallerConfig = builder.outboundCallerConfig;
        this.outboundEmailConfig = builder.outboundEmailConfig;
        this.hoursOfOperationId = builder.hoursOfOperationId;
        this.maxContacts = builder.maxContacts;
        this.status = builder.status;
        this.tags = builder.tags;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
    }

    public final String name() {
        return this.name;
    }

    public final String queueArn() {
        return this.queueArn;
    }

    public final String queueId() {
        return this.queueId;
    }

    public final String description() {
        return this.description;
    }

    public final OutboundCallerConfig outboundCallerConfig() {
        return this.outboundCallerConfig;
    }

    public final OutboundEmailConfig outboundEmailConfig() {
        return this.outboundEmailConfig;
    }

    public final String hoursOfOperationId() {
        return this.hoursOfOperationId;
    }

    public final Integer maxContacts() {
        return this.maxContacts;
    }

    public final QueueStatus status() {
        return QueueStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String lastModifiedRegion() {
        return this.lastModifiedRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.outboundCallerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outboundEmailConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hoursOfOperationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxContacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Queue)) {
            return false;
        }
        Queue other = (Queue)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.queueArn(), other.queueArn()) && Objects.equals(this.queueId(), other.queueId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.outboundCallerConfig(), other.outboundCallerConfig()) && Objects.equals(this.outboundEmailConfig(), other.outboundEmailConfig()) && Objects.equals(this.hoursOfOperationId(), other.hoursOfOperationId()) && Objects.equals(this.maxContacts(), other.maxContacts()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedRegion(), other.lastModifiedRegion());
    }

    public final String toString() {
        return ToString.builder((String)"Queue").add("Name", (Object)this.name()).add("QueueArn", (Object)this.queueArn()).add("QueueId", (Object)this.queueId()).add("Description", (Object)this.description()).add("OutboundCallerConfig", (Object)this.outboundCallerConfig()).add("OutboundEmailConfig", (Object)this.outboundEmailConfig()).add("HoursOfOperationId", (Object)this.hoursOfOperationId()).add("MaxContacts", (Object)this.maxContacts()).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedRegion", (Object)this.lastModifiedRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "QueueArn": {
                return Optional.ofNullable(clazz.cast(this.queueArn()));
            }
            case "QueueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "OutboundCallerConfig": {
                return Optional.ofNullable(clazz.cast(this.outboundCallerConfig()));
            }
            case "OutboundEmailConfig": {
                return Optional.ofNullable(clazz.cast(this.outboundEmailConfig()));
            }
            case "HoursOfOperationId": {
                return Optional.ofNullable(clazz.cast(this.hoursOfOperationId()));
            }
            case "MaxContacts": {
                return Optional.ofNullable(clazz.cast(this.maxContacts()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedRegion": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("QueueArn", QUEUE_ARN_FIELD);
        map.put("QueueId", QUEUE_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("OutboundCallerConfig", OUTBOUND_CALLER_CONFIG_FIELD);
        map.put("OutboundEmailConfig", OUTBOUND_EMAIL_CONFIG_FIELD);
        map.put("HoursOfOperationId", HOURS_OF_OPERATION_ID_FIELD);
        map.put("MaxContacts", MAX_CONTACTS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Queue, T> g) {
        return obj -> g.apply((Queue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String queueArn;
        private String queueId;
        private String description;
        private OutboundCallerConfig outboundCallerConfig;
        private OutboundEmailConfig outboundEmailConfig;
        private String hoursOfOperationId;
        private Integer maxContacts;
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Instant lastModifiedTime;
        private String lastModifiedRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(Queue model) {
            this.name(model.name);
            this.queueArn(model.queueArn);
            this.queueId(model.queueId);
            this.description(model.description);
            this.outboundCallerConfig(model.outboundCallerConfig);
            this.outboundEmailConfig(model.outboundEmailConfig);
            this.hoursOfOperationId(model.hoursOfOperationId);
            this.maxContacts(model.maxContacts);
            this.status(model.status);
            this.tags(model.tags);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedRegion(model.lastModifiedRegion);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getQueueArn() {
            return this.queueArn;
        }

        public final void setQueueArn(String queueArn) {
            this.queueArn = queueArn;
        }

        @Override
        public final Builder queueArn(String queueArn) {
            this.queueArn = queueArn;
            return this;
        }

        public final String getQueueId() {
            return this.queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final OutboundCallerConfig.Builder getOutboundCallerConfig() {
            return this.outboundCallerConfig != null ? this.outboundCallerConfig.toBuilder() : null;
        }

        public final void setOutboundCallerConfig(OutboundCallerConfig.BuilderImpl outboundCallerConfig) {
            this.outboundCallerConfig = outboundCallerConfig != null ? outboundCallerConfig.build() : null;
        }

        @Override
        public final Builder outboundCallerConfig(OutboundCallerConfig outboundCallerConfig) {
            this.outboundCallerConfig = outboundCallerConfig;
            return this;
        }

        public final OutboundEmailConfig.Builder getOutboundEmailConfig() {
            return this.outboundEmailConfig != null ? this.outboundEmailConfig.toBuilder() : null;
        }

        public final void setOutboundEmailConfig(OutboundEmailConfig.BuilderImpl outboundEmailConfig) {
            this.outboundEmailConfig = outboundEmailConfig != null ? outboundEmailConfig.build() : null;
        }

        @Override
        public final Builder outboundEmailConfig(OutboundEmailConfig outboundEmailConfig) {
            this.outboundEmailConfig = outboundEmailConfig;
            return this;
        }

        public final String getHoursOfOperationId() {
            return this.hoursOfOperationId;
        }

        public final void setHoursOfOperationId(String hoursOfOperationId) {
            this.hoursOfOperationId = hoursOfOperationId;
        }

        @Override
        public final Builder hoursOfOperationId(String hoursOfOperationId) {
            this.hoursOfOperationId = hoursOfOperationId;
            return this;
        }

        public final Integer getMaxContacts() {
            return this.maxContacts;
        }

        public final void setMaxContacts(Integer maxContacts) {
            this.maxContacts = maxContacts;
        }

        @Override
        public final Builder maxContacts(Integer maxContacts) {
            this.maxContacts = maxContacts;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QueueStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return this.lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        public Queue build() {
            return new Queue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Queue> {
        public Builder name(String var1);

        public Builder queueArn(String var1);

        public Builder queueId(String var1);

        public Builder description(String var1);

        public Builder outboundCallerConfig(OutboundCallerConfig var1);

        default public Builder outboundCallerConfig(Consumer<OutboundCallerConfig.Builder> outboundCallerConfig) {
            return this.outboundCallerConfig((OutboundCallerConfig)((OutboundCallerConfig.Builder)OutboundCallerConfig.builder().applyMutation(outboundCallerConfig)).build());
        }

        public Builder outboundEmailConfig(OutboundEmailConfig var1);

        default public Builder outboundEmailConfig(Consumer<OutboundEmailConfig.Builder> outboundEmailConfig) {
            return this.outboundEmailConfig((OutboundEmailConfig)((OutboundEmailConfig.Builder)OutboundEmailConfig.builder().applyMutation(outboundEmailConfig)).build());
        }

        public Builder hoursOfOperationId(String var1);

        public Builder maxContacts(Integer var1);

        public Builder status(String var1);

        public Builder status(QueueStatus var1);

        public Builder tags(Map<String, String> var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedRegion(String var1);
    }
}

