/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EmailHeaderType {
    REFERENCES("REFERENCES"),
    MESSAGE_ID("MESSAGE_ID"),
    IN_REPLY_TO("IN_REPLY_TO"),
    X_SES_SPAM_VERDICT("X_SES_SPAM_VERDICT"),
    X_SES_VIRUS_VERDICT("X_SES_VIRUS_VERDICT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EmailHeaderType> VALUE_MAP;
    private final String value;

    private EmailHeaderType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EmailHeaderType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EmailHeaderType> knownValues() {
        EnumSet<EmailHeaderType> knownValues = EnumSet.allOf(EmailHeaderType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EmailHeaderType.class, EmailHeaderType::toString);
    }
}

