/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.Attendee;
import software.amazon.awssdk.services.connect.model.Meeting;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectionData> {
    private static final SdkField<Attendee> ATTENDEE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Attendee").getter(ConnectionData.getter(ConnectionData::attendee)).setter(ConnectionData.setter(Builder::attendee)).constructor(Attendee::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attendee").build()}).build();
    private static final SdkField<Meeting> MEETING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Meeting").getter(ConnectionData.getter(ConnectionData::meeting)).setter(ConnectionData.setter(Builder::meeting)).constructor(Meeting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Meeting").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTENDEE_FIELD, MEETING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConnectionData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Attendee attendee;
    private final Meeting meeting;

    private ConnectionData(BuilderImpl builder) {
        this.attendee = builder.attendee;
        this.meeting = builder.meeting;
    }

    public final Attendee attendee() {
        return this.attendee;
    }

    public final Meeting meeting() {
        return this.meeting;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attendee());
        hashCode = 31 * hashCode + Objects.hashCode(this.meeting());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionData)) {
            return false;
        }
        ConnectionData other = (ConnectionData)obj;
        return Objects.equals(this.attendee(), other.attendee()) && Objects.equals(this.meeting(), other.meeting());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectionData").add("Attendee", (Object)this.attendee()).add("Meeting", (Object)this.meeting()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attendee": {
                return Optional.ofNullable(clazz.cast(this.attendee()));
            }
            case "Meeting": {
                return Optional.ofNullable(clazz.cast(this.meeting()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Attendee", ATTENDEE_FIELD);
        map.put("Meeting", MEETING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionData, T> g) {
        return obj -> g.apply((ConnectionData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Attendee attendee;
        private Meeting meeting;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionData model) {
            this.attendee(model.attendee);
            this.meeting(model.meeting);
        }

        public final Attendee.Builder getAttendee() {
            return this.attendee != null ? this.attendee.toBuilder() : null;
        }

        public final void setAttendee(Attendee.BuilderImpl attendee) {
            this.attendee = attendee != null ? attendee.build() : null;
        }

        @Override
        public final Builder attendee(Attendee attendee) {
            this.attendee = attendee;
            return this;
        }

        public final Meeting.Builder getMeeting() {
            return this.meeting != null ? this.meeting.toBuilder() : null;
        }

        public final void setMeeting(Meeting.BuilderImpl meeting) {
            this.meeting = meeting != null ? meeting.build() : null;
        }

        @Override
        public final Builder meeting(Meeting meeting) {
            this.meeting = meeting;
            return this;
        }

        public ConnectionData build() {
            return new ConnectionData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectionData> {
        public Builder attendee(Attendee var1);

        default public Builder attendee(Consumer<Attendee.Builder> attendee) {
            return this.attendee((Attendee)((Attendee.Builder)Attendee.builder().applyMutation(attendee)).build());
        }

        public Builder meeting(Meeting var1);

        default public Builder meeting(Consumer<Meeting.Builder> meeting) {
            return this.meeting((Meeting)((Meeting.Builder)Meeting.builder().applyMutation(meeting)).build());
        }
    }
}

