/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MediaStreamType {
    AUDIO("AUDIO"),
    VIDEO("VIDEO"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MediaStreamType> VALUE_MAP;
    private final String value;

    private MediaStreamType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MediaStreamType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MediaStreamType> knownValues() {
        EnumSet<MediaStreamType> knownValues = EnumSet.allOf(MediaStreamType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MediaStreamType.class, MediaStreamType::toString);
    }
}

