/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.AgentStatusSummary;
import software.amazon.awssdk.services.connect.model.AgentStatusSummaryListCopier;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAgentStatusesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListAgentStatusesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAgentStatusesResponse.getter(ListAgentStatusesResponse::nextToken)).setter(ListAgentStatusesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<AgentStatusSummary>> AGENT_STATUS_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AgentStatusSummaryList").getter(ListAgentStatusesResponse.getter(ListAgentStatusesResponse::agentStatusSummaryList)).setter(ListAgentStatusesResponse.setter(Builder::agentStatusSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentStatusSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AgentStatusSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, AGENT_STATUS_SUMMARY_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAgentStatusesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<AgentStatusSummary> agentStatusSummaryList;

    private ListAgentStatusesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.agentStatusSummaryList = builder.agentStatusSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasAgentStatusSummaryList() {
        return this.agentStatusSummaryList != null && !(this.agentStatusSummaryList instanceof SdkAutoConstructList);
    }

    public final List<AgentStatusSummary> agentStatusSummaryList() {
        return this.agentStatusSummaryList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentStatusSummaryList() ? this.agentStatusSummaryList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAgentStatusesResponse)) {
            return false;
        }
        ListAgentStatusesResponse other = (ListAgentStatusesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasAgentStatusSummaryList() == other.hasAgentStatusSummaryList() && Objects.equals(this.agentStatusSummaryList(), other.agentStatusSummaryList());
    }

    public final String toString() {
        return ToString.builder((String)"ListAgentStatusesResponse").add("NextToken", (Object)this.nextToken()).add("AgentStatusSummaryList", this.hasAgentStatusSummaryList() ? this.agentStatusSummaryList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "AgentStatusSummaryList": {
                return Optional.ofNullable(clazz.cast(this.agentStatusSummaryList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("AgentStatusSummaryList", AGENT_STATUS_SUMMARY_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAgentStatusesResponse, T> g) {
        return obj -> g.apply((ListAgentStatusesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<AgentStatusSummary> agentStatusSummaryList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAgentStatusesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.agentStatusSummaryList(model.agentStatusSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<AgentStatusSummary.Builder> getAgentStatusSummaryList() {
            List<AgentStatusSummary.Builder> result = AgentStatusSummaryListCopier.copyToBuilder(this.agentStatusSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAgentStatusSummaryList(Collection<AgentStatusSummary.BuilderImpl> agentStatusSummaryList) {
            this.agentStatusSummaryList = AgentStatusSummaryListCopier.copyFromBuilder(agentStatusSummaryList);
        }

        @Override
        public final Builder agentStatusSummaryList(Collection<AgentStatusSummary> agentStatusSummaryList) {
            this.agentStatusSummaryList = AgentStatusSummaryListCopier.copy(agentStatusSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentStatusSummaryList(AgentStatusSummary ... agentStatusSummaryList) {
            this.agentStatusSummaryList(Arrays.asList(agentStatusSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentStatusSummaryList(Consumer<AgentStatusSummary.Builder> ... agentStatusSummaryList) {
            this.agentStatusSummaryList(Stream.of(agentStatusSummaryList).map(c -> (AgentStatusSummary)((AgentStatusSummary.Builder)AgentStatusSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAgentStatusesResponse build() {
            return new ListAgentStatusesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAgentStatusesResponse> {
        public Builder nextToken(String var1);

        public Builder agentStatusSummaryList(Collection<AgentStatusSummary> var1);

        public Builder agentStatusSummaryList(AgentStatusSummary ... var1);

        public Builder agentStatusSummaryList(Consumer<AgentStatusSummary.Builder> ... var1);
    }
}

