/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.EncryptionConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KinesisVideoStreamConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KinesisVideoStreamConfig> {
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Prefix").getter(KinesisVideoStreamConfig.getter(KinesisVideoStreamConfig::prefix)).setter(KinesisVideoStreamConfig.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()}).build();
    private static final SdkField<Integer> RETENTION_PERIOD_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RetentionPeriodHours").getter(KinesisVideoStreamConfig.getter(KinesisVideoStreamConfig::retentionPeriodHours)).setter(KinesisVideoStreamConfig.setter(Builder::retentionPeriodHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriodHours").build()}).build();
    private static final SdkField<EncryptionConfig> ENCRYPTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionConfig").getter(KinesisVideoStreamConfig.getter(KinesisVideoStreamConfig::encryptionConfig)).setter(KinesisVideoStreamConfig.setter(Builder::encryptionConfig)).constructor(EncryptionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIX_FIELD, RETENTION_PERIOD_HOURS_FIELD, ENCRYPTION_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KinesisVideoStreamConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String prefix;
    private final Integer retentionPeriodHours;
    private final EncryptionConfig encryptionConfig;

    private KinesisVideoStreamConfig(BuilderImpl builder) {
        this.prefix = builder.prefix;
        this.retentionPeriodHours = builder.retentionPeriodHours;
        this.encryptionConfig = builder.encryptionConfig;
    }

    public final String prefix() {
        return this.prefix;
    }

    public final Integer retentionPeriodHours() {
        return this.retentionPeriodHours;
    }

    public final EncryptionConfig encryptionConfig() {
        return this.encryptionConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriodHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisVideoStreamConfig)) {
            return false;
        }
        KinesisVideoStreamConfig other = (KinesisVideoStreamConfig)obj;
        return Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.retentionPeriodHours(), other.retentionPeriodHours()) && Objects.equals(this.encryptionConfig(), other.encryptionConfig());
    }

    public final String toString() {
        return ToString.builder((String)"KinesisVideoStreamConfig").add("Prefix", (Object)this.prefix()).add("RetentionPeriodHours", (Object)this.retentionPeriodHours()).add("EncryptionConfig", (Object)this.encryptionConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "RetentionPeriodHours": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriodHours()));
            }
            case "EncryptionConfig": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Prefix", PREFIX_FIELD);
        map.put("RetentionPeriodHours", RETENTION_PERIOD_HOURS_FIELD);
        map.put("EncryptionConfig", ENCRYPTION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KinesisVideoStreamConfig, T> g) {
        return obj -> g.apply((KinesisVideoStreamConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String prefix;
        private Integer retentionPeriodHours;
        private EncryptionConfig encryptionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisVideoStreamConfig model) {
            this.prefix(model.prefix);
            this.retentionPeriodHours(model.retentionPeriodHours);
            this.encryptionConfig(model.encryptionConfig);
        }

        public final String getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final Integer getRetentionPeriodHours() {
            return this.retentionPeriodHours;
        }

        public final void setRetentionPeriodHours(Integer retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
        }

        @Override
        public final Builder retentionPeriodHours(Integer retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
            return this;
        }

        public final EncryptionConfig.Builder getEncryptionConfig() {
            return this.encryptionConfig != null ? this.encryptionConfig.toBuilder() : null;
        }

        public final void setEncryptionConfig(EncryptionConfig.BuilderImpl encryptionConfig) {
            this.encryptionConfig = encryptionConfig != null ? encryptionConfig.build() : null;
        }

        @Override
        public final Builder encryptionConfig(EncryptionConfig encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
            return this;
        }

        public KinesisVideoStreamConfig build() {
            return new KinesisVideoStreamConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KinesisVideoStreamConfig> {
        public Builder prefix(String var1);

        public Builder retentionPeriodHours(Integer var1);

        public Builder encryptionConfig(EncryptionConfig var1);

        default public Builder encryptionConfig(Consumer<EncryptionConfig.Builder> encryptionConfig) {
            return this.encryptionConfig((EncryptionConfig)((EncryptionConfig.Builder)EncryptionConfig.builder().applyMutation(encryptionConfig)).build());
        }
    }
}

