/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.AnalyticsDataAssociationResult;
import software.amazon.awssdk.services.connect.model.AnalyticsDataAssociationResultsCopier;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.ErrorResult;
import software.amazon.awssdk.services.connect.model.ErrorResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchAssociateAnalyticsDataSetResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, BatchAssociateAnalyticsDataSetResponse> {
    private static final SdkField<List<AnalyticsDataAssociationResult>> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Created").getter(BatchAssociateAnalyticsDataSetResponse.getter(BatchAssociateAnalyticsDataSetResponse::created)).setter(BatchAssociateAnalyticsDataSetResponse.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Created").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyticsDataAssociationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ErrorResult>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(BatchAssociateAnalyticsDataSetResponse.getter(BatchAssociateAnalyticsDataSetResponse::errors)).setter(BatchAssociateAnalyticsDataSetResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ErrorResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchAssociateAnalyticsDataSetResponse.memberNameToFieldInitializer();
    private final List<AnalyticsDataAssociationResult> created;
    private final List<ErrorResult> errors;

    private BatchAssociateAnalyticsDataSetResponse(BuilderImpl builder) {
        super(builder);
        this.created = builder.created;
        this.errors = builder.errors;
    }

    public final boolean hasCreated() {
        return this.created != null && !(this.created instanceof SdkAutoConstructList);
    }

    public final List<AnalyticsDataAssociationResult> created() {
        return this.created;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<ErrorResult> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCreated() ? this.created() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateAnalyticsDataSetResponse)) {
            return false;
        }
        BatchAssociateAnalyticsDataSetResponse other = (BatchAssociateAnalyticsDataSetResponse)((Object)obj);
        return this.hasCreated() == other.hasCreated() && Objects.equals(this.created(), other.created()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchAssociateAnalyticsDataSetResponse").add("Created", this.hasCreated() ? this.created() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Created", CREATED_FIELD);
        map.put("Errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateAnalyticsDataSetResponse, T> g) {
        return obj -> g.apply((BatchAssociateAnalyticsDataSetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<AnalyticsDataAssociationResult> created = DefaultSdkAutoConstructList.getInstance();
        private List<ErrorResult> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateAnalyticsDataSetResponse model) {
            super(model);
            this.created(model.created);
            this.errors(model.errors);
        }

        public final List<AnalyticsDataAssociationResult.Builder> getCreated() {
            List<AnalyticsDataAssociationResult.Builder> result = AnalyticsDataAssociationResultsCopier.copyToBuilder(this.created);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCreated(Collection<AnalyticsDataAssociationResult.BuilderImpl> created) {
            this.created = AnalyticsDataAssociationResultsCopier.copyFromBuilder(created);
        }

        @Override
        public final Builder created(Collection<AnalyticsDataAssociationResult> created) {
            this.created = AnalyticsDataAssociationResultsCopier.copy(created);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder created(AnalyticsDataAssociationResult ... created) {
            this.created(Arrays.asList(created));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder created(Consumer<AnalyticsDataAssociationResult.Builder> ... created) {
            this.created(Stream.of(created).map(c -> (AnalyticsDataAssociationResult)((AnalyticsDataAssociationResult.Builder)AnalyticsDataAssociationResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ErrorResult.Builder> getErrors() {
            List<ErrorResult.Builder> result = ErrorResultsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<ErrorResult.BuilderImpl> errors) {
            this.errors = ErrorResultsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<ErrorResult> errors) {
            this.errors = ErrorResultsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(ErrorResult ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<ErrorResult.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (ErrorResult)((ErrorResult.Builder)ErrorResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchAssociateAnalyticsDataSetResponse build() {
            return new BatchAssociateAnalyticsDataSetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchAssociateAnalyticsDataSetResponse> {
        public Builder created(Collection<AnalyticsDataAssociationResult> var1);

        public Builder created(AnalyticsDataAssociationResult ... var1);

        public Builder created(Consumer<AnalyticsDataAssociationResult.Builder> ... var1);

        public Builder errors(Collection<ErrorResult> var1);

        public Builder errors(ErrorResult ... var1);

        public Builder errors(Consumer<ErrorResult.Builder> ... var1);
    }
}

