/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ControlPlaneTagFilter;
import software.amazon.awssdk.services.connect.model.ControlPlaneUserAttributeFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserSearchFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserSearchFilter> {
    private static final SdkField<ControlPlaneTagFilter> TAG_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TagFilter").getter(UserSearchFilter.getter(UserSearchFilter::tagFilter)).setter(UserSearchFilter.setter(Builder::tagFilter)).constructor(ControlPlaneTagFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagFilter").build()}).build();
    private static final SdkField<ControlPlaneUserAttributeFilter> USER_ATTRIBUTE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserAttributeFilter").getter(UserSearchFilter.getter(UserSearchFilter::userAttributeFilter)).setter(UserSearchFilter.setter(Builder::userAttributeFilter)).constructor(ControlPlaneUserAttributeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAttributeFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_FILTER_FIELD, USER_ATTRIBUTE_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UserSearchFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ControlPlaneTagFilter tagFilter;
    private final ControlPlaneUserAttributeFilter userAttributeFilter;

    private UserSearchFilter(BuilderImpl builder) {
        this.tagFilter = builder.tagFilter;
        this.userAttributeFilter = builder.userAttributeFilter;
    }

    public final ControlPlaneTagFilter tagFilter() {
        return this.tagFilter;
    }

    public final ControlPlaneUserAttributeFilter userAttributeFilter() {
        return this.userAttributeFilter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tagFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.userAttributeFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserSearchFilter)) {
            return false;
        }
        UserSearchFilter other = (UserSearchFilter)obj;
        return Objects.equals(this.tagFilter(), other.tagFilter()) && Objects.equals(this.userAttributeFilter(), other.userAttributeFilter());
    }

    public final String toString() {
        return ToString.builder((String)"UserSearchFilter").add("TagFilter", (Object)this.tagFilter()).add("UserAttributeFilter", (Object)this.userAttributeFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TagFilter": {
                return Optional.ofNullable(clazz.cast(this.tagFilter()));
            }
            case "UserAttributeFilter": {
                return Optional.ofNullable(clazz.cast(this.userAttributeFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TagFilter", TAG_FILTER_FIELD);
        map.put("UserAttributeFilter", USER_ATTRIBUTE_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserSearchFilter, T> g) {
        return obj -> g.apply((UserSearchFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ControlPlaneTagFilter tagFilter;
        private ControlPlaneUserAttributeFilter userAttributeFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(UserSearchFilter model) {
            this.tagFilter(model.tagFilter);
            this.userAttributeFilter(model.userAttributeFilter);
        }

        public final ControlPlaneTagFilter.Builder getTagFilter() {
            return this.tagFilter != null ? this.tagFilter.toBuilder() : null;
        }

        public final void setTagFilter(ControlPlaneTagFilter.BuilderImpl tagFilter) {
            this.tagFilter = tagFilter != null ? tagFilter.build() : null;
        }

        @Override
        public final Builder tagFilter(ControlPlaneTagFilter tagFilter) {
            this.tagFilter = tagFilter;
            return this;
        }

        public final ControlPlaneUserAttributeFilter.Builder getUserAttributeFilter() {
            return this.userAttributeFilter != null ? this.userAttributeFilter.toBuilder() : null;
        }

        public final void setUserAttributeFilter(ControlPlaneUserAttributeFilter.BuilderImpl userAttributeFilter) {
            this.userAttributeFilter = userAttributeFilter != null ? userAttributeFilter.build() : null;
        }

        @Override
        public final Builder userAttributeFilter(ControlPlaneUserAttributeFilter userAttributeFilter) {
            this.userAttributeFilter = userAttributeFilter;
            return this;
        }

        public UserSearchFilter build() {
            return new UserSearchFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserSearchFilter> {
        public Builder tagFilter(ControlPlaneTagFilter var1);

        default public Builder tagFilter(Consumer<ControlPlaneTagFilter.Builder> tagFilter) {
            return this.tagFilter((ControlPlaneTagFilter)((ControlPlaneTagFilter.Builder)ControlPlaneTagFilter.builder().applyMutation(tagFilter)).build());
        }

        public Builder userAttributeFilter(ControlPlaneUserAttributeFilter var1);

        default public Builder userAttributeFilter(Consumer<ControlPlaneUserAttributeFilter.Builder> userAttributeFilter) {
            return this.userAttributeFilter((ControlPlaneUserAttributeFilter)((ControlPlaneUserAttributeFilter.Builder)ControlPlaneUserAttributeFilter.builder().applyMutation(userAttributeFilter)).build());
        }
    }
}

