/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.TemplateAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TemplatedMessageConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TemplatedMessageConfig> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KnowledgeBaseId").getter(TemplatedMessageConfig.getter(TemplatedMessageConfig::knowledgeBaseId)).setter(TemplatedMessageConfig.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KnowledgeBaseId").build()}).build();
    private static final SdkField<String> MESSAGE_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageTemplateId").getter(TemplatedMessageConfig.getter(TemplatedMessageConfig::messageTemplateId)).setter(TemplatedMessageConfig.setter(Builder::messageTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageTemplateId").build()}).build();
    private static final SdkField<TemplateAttributes> TEMPLATE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TemplateAttributes").getter(TemplatedMessageConfig.getter(TemplatedMessageConfig::templateAttributes)).setter(TemplatedMessageConfig.setter(Builder::templateAttributes)).constructor(TemplateAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD, MESSAGE_TEMPLATE_ID_FIELD, TEMPLATE_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TemplatedMessageConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String knowledgeBaseId;
    private final String messageTemplateId;
    private final TemplateAttributes templateAttributes;

    private TemplatedMessageConfig(BuilderImpl builder) {
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.messageTemplateId = builder.messageTemplateId;
        this.templateAttributes = builder.templateAttributes;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final String messageTemplateId() {
        return this.messageTemplateId;
    }

    public final TemplateAttributes templateAttributes() {
        return this.templateAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplatedMessageConfig)) {
            return false;
        }
        TemplatedMessageConfig other = (TemplatedMessageConfig)obj;
        return Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.messageTemplateId(), other.messageTemplateId()) && Objects.equals(this.templateAttributes(), other.templateAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"TemplatedMessageConfig").add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("MessageTemplateId", (Object)this.messageTemplateId()).add("TemplateAttributes", (Object)this.templateAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KnowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "MessageTemplateId": {
                return Optional.ofNullable(clazz.cast(this.messageTemplateId()));
            }
            case "TemplateAttributes": {
                return Optional.ofNullable(clazz.cast(this.templateAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KnowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("MessageTemplateId", MESSAGE_TEMPLATE_ID_FIELD);
        map.put("TemplateAttributes", TEMPLATE_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TemplatedMessageConfig, T> g) {
        return obj -> g.apply((TemplatedMessageConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String knowledgeBaseId;
        private String messageTemplateId;
        private TemplateAttributes templateAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplatedMessageConfig model) {
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.messageTemplateId(model.messageTemplateId);
            this.templateAttributes(model.templateAttributes);
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getMessageTemplateId() {
            return this.messageTemplateId;
        }

        public final void setMessageTemplateId(String messageTemplateId) {
            this.messageTemplateId = messageTemplateId;
        }

        @Override
        public final Builder messageTemplateId(String messageTemplateId) {
            this.messageTemplateId = messageTemplateId;
            return this;
        }

        public final TemplateAttributes.Builder getTemplateAttributes() {
            return this.templateAttributes != null ? this.templateAttributes.toBuilder() : null;
        }

        public final void setTemplateAttributes(TemplateAttributes.BuilderImpl templateAttributes) {
            this.templateAttributes = templateAttributes != null ? templateAttributes.build() : null;
        }

        @Override
        public final Builder templateAttributes(TemplateAttributes templateAttributes) {
            this.templateAttributes = templateAttributes;
            return this;
        }

        public TemplatedMessageConfig build() {
            return new TemplatedMessageConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TemplatedMessageConfig> {
        public Builder knowledgeBaseId(String var1);

        public Builder messageTemplateId(String var1);

        public Builder templateAttributes(TemplateAttributes var1);

        default public Builder templateAttributes(Consumer<TemplateAttributes.Builder> templateAttributes) {
            return this.templateAttributes((TemplateAttributes)((TemplateAttributes.Builder)TemplateAttributes.builder().applyMutation(templateAttributes)).build());
        }
    }
}

