/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ParticipantRole;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContactConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContactConfiguration> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactId").getter(ContactConfiguration.getter(ContactConfiguration::contactId)).setter(ContactConfiguration.setter(Builder::contactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()}).build();
    private static final SdkField<String> PARTICIPANT_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParticipantRole").getter(ContactConfiguration.getter(ContactConfiguration::participantRoleAsString)).setter(ContactConfiguration.setter(Builder::participantRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantRole").build()}).build();
    private static final SdkField<Boolean> INCLUDE_RAW_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeRawMessage").getter(ContactConfiguration.getter(ContactConfiguration::includeRawMessage)).setter(ContactConfiguration.setter(Builder::includeRawMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeRawMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD, PARTICIPANT_ROLE_FIELD, INCLUDE_RAW_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContactConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String contactId;
    private final String participantRole;
    private final Boolean includeRawMessage;

    private ContactConfiguration(BuilderImpl builder) {
        this.contactId = builder.contactId;
        this.participantRole = builder.participantRole;
        this.includeRawMessage = builder.includeRawMessage;
    }

    public final String contactId() {
        return this.contactId;
    }

    public final ParticipantRole participantRole() {
        return ParticipantRole.fromValue(this.participantRole);
    }

    public final String participantRoleAsString() {
        return this.participantRole;
    }

    public final Boolean includeRawMessage() {
        return this.includeRawMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeRawMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactConfiguration)) {
            return false;
        }
        ContactConfiguration other = (ContactConfiguration)obj;
        return Objects.equals(this.contactId(), other.contactId()) && Objects.equals(this.participantRoleAsString(), other.participantRoleAsString()) && Objects.equals(this.includeRawMessage(), other.includeRawMessage());
    }

    public final String toString() {
        return ToString.builder((String)"ContactConfiguration").add("ContactId", (Object)this.contactId()).add("ParticipantRole", (Object)this.participantRoleAsString()).add("IncludeRawMessage", (Object)this.includeRawMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactId": {
                return Optional.ofNullable(clazz.cast(this.contactId()));
            }
            case "ParticipantRole": {
                return Optional.ofNullable(clazz.cast(this.participantRoleAsString()));
            }
            case "IncludeRawMessage": {
                return Optional.ofNullable(clazz.cast(this.includeRawMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ContactId", CONTACT_ID_FIELD);
        map.put("ParticipantRole", PARTICIPANT_ROLE_FIELD);
        map.put("IncludeRawMessage", INCLUDE_RAW_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactConfiguration, T> g) {
        return obj -> g.apply((ContactConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String contactId;
        private String participantRole;
        private Boolean includeRawMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactConfiguration model) {
            this.contactId(model.contactId);
            this.participantRole(model.participantRole);
            this.includeRawMessage(model.includeRawMessage);
        }

        public final String getContactId() {
            return this.contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getParticipantRole() {
            return this.participantRole;
        }

        public final void setParticipantRole(String participantRole) {
            this.participantRole = participantRole;
        }

        @Override
        public final Builder participantRole(String participantRole) {
            this.participantRole = participantRole;
            return this;
        }

        @Override
        public final Builder participantRole(ParticipantRole participantRole) {
            this.participantRole(participantRole == null ? null : participantRole.toString());
            return this;
        }

        public final Boolean getIncludeRawMessage() {
            return this.includeRawMessage;
        }

        public final void setIncludeRawMessage(Boolean includeRawMessage) {
            this.includeRawMessage = includeRawMessage;
        }

        @Override
        public final Builder includeRawMessage(Boolean includeRawMessage) {
            this.includeRawMessage = includeRawMessage;
            return this;
        }

        public ContactConfiguration build() {
            return new ContactConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContactConfiguration> {
        public Builder contactId(String var1);

        public Builder participantRole(String var1);

        public Builder participantRole(ParticipantRole var1);

        public Builder includeRawMessage(Boolean var1);
    }
}

