/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.FileIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetAttachedFileMetadataRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, BatchGetAttachedFileMetadataRequest> {
    private static final SdkField<List<String>> FILE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FileIds").getter(BatchGetAttachedFileMetadataRequest.getter(BatchGetAttachedFileMetadataRequest::fileIds)).setter(BatchGetAttachedFileMetadataRequest.setter(Builder::fileIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(BatchGetAttachedFileMetadataRequest.getter(BatchGetAttachedFileMetadataRequest::instanceId)).setter(BatchGetAttachedFileMetadataRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> ASSOCIATED_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociatedResourceArn").getter(BatchGetAttachedFileMetadataRequest.getter(BatchGetAttachedFileMetadataRequest::associatedResourceArn)).setter(BatchGetAttachedFileMetadataRequest.setter(Builder::associatedResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("associatedResourceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_IDS_FIELD, INSTANCE_ID_FIELD, ASSOCIATED_RESOURCE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetAttachedFileMetadataRequest.memberNameToFieldInitializer();
    private final List<String> fileIds;
    private final String instanceId;
    private final String associatedResourceArn;

    private BatchGetAttachedFileMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.fileIds = builder.fileIds;
        this.instanceId = builder.instanceId;
        this.associatedResourceArn = builder.associatedResourceArn;
    }

    public final boolean hasFileIds() {
        return this.fileIds != null && !(this.fileIds instanceof SdkAutoConstructList);
    }

    public final List<String> fileIds() {
        return this.fileIds;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String associatedResourceArn() {
        return this.associatedResourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFileIds() ? this.fileIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedResourceArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAttachedFileMetadataRequest)) {
            return false;
        }
        BatchGetAttachedFileMetadataRequest other = (BatchGetAttachedFileMetadataRequest)((Object)obj);
        return this.hasFileIds() == other.hasFileIds() && Objects.equals(this.fileIds(), other.fileIds()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.associatedResourceArn(), other.associatedResourceArn());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetAttachedFileMetadataRequest").add("FileIds", this.hasFileIds() ? this.fileIds() : null).add("InstanceId", (Object)this.instanceId()).add("AssociatedResourceArn", (Object)this.associatedResourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileIds": {
                return Optional.ofNullable(clazz.cast(this.fileIds()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "AssociatedResourceArn": {
                return Optional.ofNullable(clazz.cast(this.associatedResourceArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FileIds", FILE_IDS_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("associatedResourceArn", ASSOCIATED_RESOURCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAttachedFileMetadataRequest, T> g) {
        return obj -> g.apply((BatchGetAttachedFileMetadataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private List<String> fileIds = DefaultSdkAutoConstructList.getInstance();
        private String instanceId;
        private String associatedResourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAttachedFileMetadataRequest model) {
            super(model);
            this.fileIds(model.fileIds);
            this.instanceId(model.instanceId);
            this.associatedResourceArn(model.associatedResourceArn);
        }

        public final Collection<String> getFileIds() {
            if (this.fileIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fileIds;
        }

        public final void setFileIds(Collection<String> fileIds) {
            this.fileIds = FileIdListCopier.copy(fileIds);
        }

        @Override
        public final Builder fileIds(Collection<String> fileIds) {
            this.fileIds = FileIdListCopier.copy(fileIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileIds(String ... fileIds) {
            this.fileIds(Arrays.asList(fileIds));
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getAssociatedResourceArn() {
            return this.associatedResourceArn;
        }

        public final void setAssociatedResourceArn(String associatedResourceArn) {
            this.associatedResourceArn = associatedResourceArn;
        }

        @Override
        public final Builder associatedResourceArn(String associatedResourceArn) {
            this.associatedResourceArn = associatedResourceArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetAttachedFileMetadataRequest build() {
            return new BatchGetAttachedFileMetadataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetAttachedFileMetadataRequest> {
        public Builder fileIds(Collection<String> var1);

        public Builder fileIds(String ... var1);

        public Builder instanceId(String var1);

        public Builder associatedResourceArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

