/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.DimensionsV2MapCopier;
import software.amazon.awssdk.services.connect.model.MetricDataCollectionsV2Copier;
import software.amazon.awssdk.services.connect.model.MetricDataV2;
import software.amazon.awssdk.services.connect.model.MetricInterval;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricResultV2
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricResultV2> {
    private static final SdkField<Map<String, String>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Dimensions").getter(MetricResultV2.getter(MetricResultV2::dimensions)).setter(MetricResultV2.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<MetricInterval> METRIC_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetricInterval").getter(MetricResultV2.getter(MetricResultV2::metricInterval)).setter(MetricResultV2.setter(Builder::metricInterval)).constructor(MetricInterval::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricInterval").build()}).build();
    private static final SdkField<List<MetricDataV2>> COLLECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Collections").getter(MetricResultV2.getter(MetricResultV2::collections)).setter(MetricResultV2.setter(Builder::collections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Collections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDataV2::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD, METRIC_INTERVAL_FIELD, COLLECTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetricResultV2.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> dimensions;
    private final MetricInterval metricInterval;
    private final List<MetricDataV2> collections;

    private MetricResultV2(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.metricInterval = builder.metricInterval;
        this.collections = builder.collections;
    }

    public final boolean hasDimensions() {
        return this.dimensions != null && !(this.dimensions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> dimensions() {
        return this.dimensions;
    }

    public final MetricInterval metricInterval() {
        return this.metricInterval;
    }

    public final boolean hasCollections() {
        return this.collections != null && !(this.collections instanceof SdkAutoConstructList);
    }

    public final List<MetricDataV2> collections() {
        return this.collections;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensions() ? this.dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.metricInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCollections() ? this.collections() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricResultV2)) {
            return false;
        }
        MetricResultV2 other = (MetricResultV2)obj;
        return this.hasDimensions() == other.hasDimensions() && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.metricInterval(), other.metricInterval()) && this.hasCollections() == other.hasCollections() && Objects.equals(this.collections(), other.collections());
    }

    public final String toString() {
        return ToString.builder((String)"MetricResultV2").add("Dimensions", this.hasDimensions() ? this.dimensions() : null).add("MetricInterval", (Object)this.metricInterval()).add("Collections", this.hasCollections() ? this.collections() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "MetricInterval": {
                return Optional.ofNullable(clazz.cast(this.metricInterval()));
            }
            case "Collections": {
                return Optional.ofNullable(clazz.cast(this.collections()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Dimensions", DIMENSIONS_FIELD);
        map.put("MetricInterval", METRIC_INTERVAL_FIELD);
        map.put("Collections", COLLECTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricResultV2, T> g) {
        return obj -> g.apply((MetricResultV2)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> dimensions = DefaultSdkAutoConstructMap.getInstance();
        private MetricInterval metricInterval;
        private List<MetricDataV2> collections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricResultV2 model) {
            this.dimensions(model.dimensions);
            this.metricInterval(model.metricInterval);
            this.collections(model.collections);
        }

        public final Map<String, String> getDimensions() {
            if (this.dimensions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.dimensions;
        }

        public final void setDimensions(Map<String, String> dimensions) {
            this.dimensions = DimensionsV2MapCopier.copy(dimensions);
        }

        @Override
        public final Builder dimensions(Map<String, String> dimensions) {
            this.dimensions = DimensionsV2MapCopier.copy(dimensions);
            return this;
        }

        public final MetricInterval.Builder getMetricInterval() {
            return this.metricInterval != null ? this.metricInterval.toBuilder() : null;
        }

        public final void setMetricInterval(MetricInterval.BuilderImpl metricInterval) {
            this.metricInterval = metricInterval != null ? metricInterval.build() : null;
        }

        @Override
        public final Builder metricInterval(MetricInterval metricInterval) {
            this.metricInterval = metricInterval;
            return this;
        }

        public final List<MetricDataV2.Builder> getCollections() {
            List<MetricDataV2.Builder> result = MetricDataCollectionsV2Copier.copyToBuilder(this.collections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollections(Collection<MetricDataV2.BuilderImpl> collections) {
            this.collections = MetricDataCollectionsV2Copier.copyFromBuilder(collections);
        }

        @Override
        public final Builder collections(Collection<MetricDataV2> collections) {
            this.collections = MetricDataCollectionsV2Copier.copy(collections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collections(MetricDataV2 ... collections) {
            this.collections(Arrays.asList(collections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collections(Consumer<MetricDataV2.Builder> ... collections) {
            this.collections(Stream.of(collections).map(c -> (MetricDataV2)((MetricDataV2.Builder)MetricDataV2.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MetricResultV2 build() {
            return new MetricResultV2(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricResultV2> {
        public Builder dimensions(Map<String, String> var1);

        public Builder metricInterval(MetricInterval var1);

        default public Builder metricInterval(Consumer<MetricInterval.Builder> metricInterval) {
            return this.metricInterval((MetricInterval)((MetricInterval.Builder)MetricInterval.builder().applyMutation(metricInterval)).build());
        }

        public Builder collections(Collection<MetricDataV2> var1);

        public Builder collections(MetricDataV2 ... var1);

        public Builder collections(Consumer<MetricDataV2.Builder> ... var1);
    }
}

