/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.EmailAddressListCopier;
import software.amazon.awssdk.services.connect.model.EmailAddressMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchEmailAddressesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, SearchEmailAddressesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchEmailAddressesResponse.getter(SearchEmailAddressesResponse::nextToken)).setter(SearchEmailAddressesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<EmailAddressMetadata>> EMAIL_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EmailAddresses").getter(SearchEmailAddressesResponse.getter(SearchEmailAddressesResponse::emailAddresses)).setter(SearchEmailAddressesResponse.setter(Builder::emailAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EmailAddressMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> APPROXIMATE_TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApproximateTotalCount").getter(SearchEmailAddressesResponse.getter(SearchEmailAddressesResponse::approximateTotalCount)).setter(SearchEmailAddressesResponse.setter(Builder::approximateTotalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateTotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, EMAIL_ADDRESSES_FIELD, APPROXIMATE_TOTAL_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchEmailAddressesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<EmailAddressMetadata> emailAddresses;
    private final Long approximateTotalCount;

    private SearchEmailAddressesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.emailAddresses = builder.emailAddresses;
        this.approximateTotalCount = builder.approximateTotalCount;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasEmailAddresses() {
        return this.emailAddresses != null && !(this.emailAddresses instanceof SdkAutoConstructList);
    }

    public final List<EmailAddressMetadata> emailAddresses() {
        return this.emailAddresses;
    }

    public final Long approximateTotalCount() {
        return this.approximateTotalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEmailAddresses() ? this.emailAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateTotalCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchEmailAddressesResponse)) {
            return false;
        }
        SearchEmailAddressesResponse other = (SearchEmailAddressesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasEmailAddresses() == other.hasEmailAddresses() && Objects.equals(this.emailAddresses(), other.emailAddresses()) && Objects.equals(this.approximateTotalCount(), other.approximateTotalCount());
    }

    public final String toString() {
        return ToString.builder((String)"SearchEmailAddressesResponse").add("NextToken", (Object)this.nextToken()).add("EmailAddresses", this.hasEmailAddresses() ? this.emailAddresses() : null).add("ApproximateTotalCount", (Object)this.approximateTotalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "EmailAddresses": {
                return Optional.ofNullable(clazz.cast(this.emailAddresses()));
            }
            case "ApproximateTotalCount": {
                return Optional.ofNullable(clazz.cast(this.approximateTotalCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("EmailAddresses", EMAIL_ADDRESSES_FIELD);
        map.put("ApproximateTotalCount", APPROXIMATE_TOTAL_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchEmailAddressesResponse, T> g) {
        return obj -> g.apply((SearchEmailAddressesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<EmailAddressMetadata> emailAddresses = DefaultSdkAutoConstructList.getInstance();
        private Long approximateTotalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchEmailAddressesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.emailAddresses(model.emailAddresses);
            this.approximateTotalCount(model.approximateTotalCount);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<EmailAddressMetadata.Builder> getEmailAddresses() {
            List<EmailAddressMetadata.Builder> result = EmailAddressListCopier.copyToBuilder(this.emailAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEmailAddresses(Collection<EmailAddressMetadata.BuilderImpl> emailAddresses) {
            this.emailAddresses = EmailAddressListCopier.copyFromBuilder(emailAddresses);
        }

        @Override
        public final Builder emailAddresses(Collection<EmailAddressMetadata> emailAddresses) {
            this.emailAddresses = EmailAddressListCopier.copy(emailAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emailAddresses(EmailAddressMetadata ... emailAddresses) {
            this.emailAddresses(Arrays.asList(emailAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emailAddresses(Consumer<EmailAddressMetadata.Builder> ... emailAddresses) {
            this.emailAddresses(Stream.of(emailAddresses).map(c -> (EmailAddressMetadata)((EmailAddressMetadata.Builder)EmailAddressMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getApproximateTotalCount() {
            return this.approximateTotalCount;
        }

        public final void setApproximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
        }

        @Override
        public final Builder approximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
            return this;
        }

        @Override
        public SearchEmailAddressesResponse build() {
            return new SearchEmailAddressesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchEmailAddressesResponse> {
        public Builder nextToken(String var1);

        public Builder emailAddresses(Collection<EmailAddressMetadata> var1);

        public Builder emailAddresses(EmailAddressMetadata ... var1);

        public Builder emailAddresses(Consumer<EmailAddressMetadata.Builder> ... var1);

        public Builder approximateTotalCount(Long var1);
    }
}

