/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.Prompt;
import software.amazon.awssdk.services.connect.model.SearchPromptsRequest;
import software.amazon.awssdk.services.connect.model.SearchPromptsResponse;

public class SearchPromptsIterable
implements SdkIterable<SearchPromptsResponse> {
    private final ConnectClient client;
    private final SearchPromptsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchPromptsIterable(ConnectClient client, SearchPromptsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchPromptsResponseFetcher();
    }

    public Iterator<SearchPromptsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Prompt> prompts() {
        Function<SearchPromptsResponse, Iterator> getIterator = response -> {
            if (response != null && response.prompts() != null) {
                return response.prompts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchPromptsResponseFetcher
    implements SyncPageFetcher<SearchPromptsResponse> {
        private SearchPromptsResponseFetcher() {
        }

        public boolean hasNextPage(SearchPromptsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchPromptsResponse nextPage(SearchPromptsResponse previousPage) {
            if (previousPage == null) {
                return SearchPromptsIterable.this.client.searchPrompts(SearchPromptsIterable.this.firstRequest);
            }
            return SearchPromptsIterable.this.client.searchPrompts((SearchPromptsRequest)((Object)SearchPromptsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

