/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsRequest;
import software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsResponse;
import software.amazon.awssdk.services.connect.model.QuickConnectSummary;

public class ListQueueQuickConnectsPublisher
implements SdkPublisher<ListQueueQuickConnectsResponse> {
    private final ConnectAsyncClient client;
    private final ListQueueQuickConnectsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListQueueQuickConnectsPublisher(ConnectAsyncClient client, ListQueueQuickConnectsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListQueueQuickConnectsPublisher(ConnectAsyncClient client, ListQueueQuickConnectsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListQueueQuickConnectsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListQueueQuickConnectsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<QuickConnectSummary> quickConnectSummaryList() {
        Function<ListQueueQuickConnectsResponse, Iterator> getIterator = response -> {
            if (response != null && response.quickConnectSummaryList() != null) {
                return response.quickConnectSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListQueueQuickConnectsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListQueueQuickConnectsResponseFetcher
    implements AsyncPageFetcher<ListQueueQuickConnectsResponse> {
        private ListQueueQuickConnectsResponseFetcher() {
        }

        public boolean hasNextPage(ListQueueQuickConnectsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListQueueQuickConnectsResponse> nextPage(ListQueueQuickConnectsResponse previousPage) {
            if (previousPage == null) {
                return ListQueueQuickConnectsPublisher.this.client.listQueueQuickConnects(ListQueueQuickConnectsPublisher.this.firstRequest);
            }
            return ListQueueQuickConnectsPublisher.this.client.listQueueQuickConnects((ListQueueQuickConnectsRequest)((Object)ListQueueQuickConnectsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

