/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.AgentQualityMetrics;
import software.amazon.awssdk.services.connect.model.CustomerQualityMetrics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QualityMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QualityMetrics> {
    private static final SdkField<AgentQualityMetrics> AGENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Agent").getter(QualityMetrics.getter(QualityMetrics::agent)).setter(QualityMetrics.setter(Builder::agent)).constructor(AgentQualityMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Agent").build()}).build();
    private static final SdkField<CustomerQualityMetrics> CUSTOMER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Customer").getter(QualityMetrics.getter(QualityMetrics::customer)).setter(QualityMetrics.setter(Builder::customer)).constructor(CustomerQualityMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Customer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_FIELD, CUSTOMER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = QualityMetrics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AgentQualityMetrics agent;
    private final CustomerQualityMetrics customer;

    private QualityMetrics(BuilderImpl builder) {
        this.agent = builder.agent;
        this.customer = builder.customer;
    }

    public final AgentQualityMetrics agent() {
        return this.agent;
    }

    public final CustomerQualityMetrics customer() {
        return this.customer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.agent());
        hashCode = 31 * hashCode + Objects.hashCode(this.customer());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QualityMetrics)) {
            return false;
        }
        QualityMetrics other = (QualityMetrics)obj;
        return Objects.equals(this.agent(), other.agent()) && Objects.equals(this.customer(), other.customer());
    }

    public final String toString() {
        return ToString.builder((String)"QualityMetrics").add("Agent", (Object)this.agent()).add("Customer", (Object)this.customer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Agent": {
                return Optional.ofNullable(clazz.cast(this.agent()));
            }
            case "Customer": {
                return Optional.ofNullable(clazz.cast(this.customer()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Agent", AGENT_FIELD);
        map.put("Customer", CUSTOMER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QualityMetrics, T> g) {
        return obj -> g.apply((QualityMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AgentQualityMetrics agent;
        private CustomerQualityMetrics customer;

        private BuilderImpl() {
        }

        private BuilderImpl(QualityMetrics model) {
            this.agent(model.agent);
            this.customer(model.customer);
        }

        public final AgentQualityMetrics.Builder getAgent() {
            return this.agent != null ? this.agent.toBuilder() : null;
        }

        public final void setAgent(AgentQualityMetrics.BuilderImpl agent) {
            this.agent = agent != null ? agent.build() : null;
        }

        @Override
        public final Builder agent(AgentQualityMetrics agent) {
            this.agent = agent;
            return this;
        }

        public final CustomerQualityMetrics.Builder getCustomer() {
            return this.customer != null ? this.customer.toBuilder() : null;
        }

        public final void setCustomer(CustomerQualityMetrics.BuilderImpl customer) {
            this.customer = customer != null ? customer.build() : null;
        }

        @Override
        public final Builder customer(CustomerQualityMetrics customer) {
            this.customer = customer;
            return this;
        }

        public QualityMetrics build() {
            return new QualityMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QualityMetrics> {
        public Builder agent(AgentQualityMetrics var1);

        default public Builder agent(Consumer<AgentQualityMetrics.Builder> agent) {
            return this.agent((AgentQualityMetrics)((AgentQualityMetrics.Builder)AgentQualityMetrics.builder().applyMutation(agent)).build());
        }

        public Builder customer(CustomerQualityMetrics var1);

        default public Builder customer(Consumer<CustomerQualityMetrics.Builder> customer) {
            return this.customer((CustomerQualityMetrics)((CustomerQualityMetrics.Builder)CustomerQualityMetrics.builder().applyMutation(customer)).build());
        }
    }
}

