/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.ReferenceSummary;
import software.amazon.awssdk.services.connect.model.ReferenceSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListContactReferencesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListContactReferencesResponse> {
    private static final SdkField<List<ReferenceSummary>> REFERENCE_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReferenceSummaryList").getter(ListContactReferencesResponse.getter(ListContactReferencesResponse::referenceSummaryList)).setter(ListContactReferencesResponse.setter(Builder::referenceSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReferenceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListContactReferencesResponse.getter(ListContactReferencesResponse::nextToken)).setter(ListContactReferencesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCE_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListContactReferencesResponse.memberNameToFieldInitializer();
    private final List<ReferenceSummary> referenceSummaryList;
    private final String nextToken;

    private ListContactReferencesResponse(BuilderImpl builder) {
        super(builder);
        this.referenceSummaryList = builder.referenceSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasReferenceSummaryList() {
        return this.referenceSummaryList != null && !(this.referenceSummaryList instanceof SdkAutoConstructList);
    }

    public final List<ReferenceSummary> referenceSummaryList() {
        return this.referenceSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferenceSummaryList() ? this.referenceSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContactReferencesResponse)) {
            return false;
        }
        ListContactReferencesResponse other = (ListContactReferencesResponse)((Object)obj);
        return this.hasReferenceSummaryList() == other.hasReferenceSummaryList() && Objects.equals(this.referenceSummaryList(), other.referenceSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListContactReferencesResponse").add("ReferenceSummaryList", this.hasReferenceSummaryList() ? this.referenceSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReferenceSummaryList": {
                return Optional.ofNullable(clazz.cast(this.referenceSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReferenceSummaryList", REFERENCE_SUMMARY_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListContactReferencesResponse, T> g) {
        return obj -> g.apply((ListContactReferencesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<ReferenceSummary> referenceSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContactReferencesResponse model) {
            super(model);
            this.referenceSummaryList(model.referenceSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<ReferenceSummary.Builder> getReferenceSummaryList() {
            List<ReferenceSummary.Builder> result = ReferenceSummaryListCopier.copyToBuilder(this.referenceSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReferenceSummaryList(Collection<ReferenceSummary.BuilderImpl> referenceSummaryList) {
            this.referenceSummaryList = ReferenceSummaryListCopier.copyFromBuilder(referenceSummaryList);
        }

        @Override
        public final Builder referenceSummaryList(Collection<ReferenceSummary> referenceSummaryList) {
            this.referenceSummaryList = ReferenceSummaryListCopier.copy(referenceSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceSummaryList(ReferenceSummary ... referenceSummaryList) {
            this.referenceSummaryList(Arrays.asList(referenceSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceSummaryList(Consumer<ReferenceSummary.Builder> ... referenceSummaryList) {
            this.referenceSummaryList(Stream.of(referenceSummaryList).map(c -> (ReferenceSummary)((ReferenceSummary.Builder)ReferenceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListContactReferencesResponse build() {
            return new ListContactReferencesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListContactReferencesResponse> {
        public Builder referenceSummaryList(Collection<ReferenceSummary> var1);

        public Builder referenceSummaryList(ReferenceSummary ... var1);

        public Builder referenceSummaryList(Consumer<ReferenceSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

