/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.OperationalHour;
import software.amazon.awssdk.services.connect.model.OperationalHoursCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EffectiveHoursOfOperations
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EffectiveHoursOfOperations> {
    private static final SdkField<String> DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Date").getter(EffectiveHoursOfOperations.getter(EffectiveHoursOfOperations::date)).setter(EffectiveHoursOfOperations.setter(Builder::date)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Date").build()}).build();
    private static final SdkField<List<OperationalHour>> OPERATIONAL_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OperationalHours").getter(EffectiveHoursOfOperations.getter(EffectiveHoursOfOperations::operationalHours)).setter(EffectiveHoursOfOperations.setter(Builder::operationalHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationalHours").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OperationalHour::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_FIELD, OPERATIONAL_HOURS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EffectiveHoursOfOperations.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String date;
    private final List<OperationalHour> operationalHours;

    private EffectiveHoursOfOperations(BuilderImpl builder) {
        this.date = builder.date;
        this.operationalHours = builder.operationalHours;
    }

    public final String date() {
        return this.date;
    }

    public final boolean hasOperationalHours() {
        return this.operationalHours != null && !(this.operationalHours instanceof SdkAutoConstructList);
    }

    public final List<OperationalHour> operationalHours() {
        return this.operationalHours;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.date());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperationalHours() ? this.operationalHours() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EffectiveHoursOfOperations)) {
            return false;
        }
        EffectiveHoursOfOperations other = (EffectiveHoursOfOperations)obj;
        return Objects.equals(this.date(), other.date()) && this.hasOperationalHours() == other.hasOperationalHours() && Objects.equals(this.operationalHours(), other.operationalHours());
    }

    public final String toString() {
        return ToString.builder((String)"EffectiveHoursOfOperations").add("Date", (Object)this.date()).add("OperationalHours", this.hasOperationalHours() ? this.operationalHours() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Date": {
                return Optional.ofNullable(clazz.cast(this.date()));
            }
            case "OperationalHours": {
                return Optional.ofNullable(clazz.cast(this.operationalHours()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Date", DATE_FIELD);
        map.put("OperationalHours", OPERATIONAL_HOURS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EffectiveHoursOfOperations, T> g) {
        return obj -> g.apply((EffectiveHoursOfOperations)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String date;
        private List<OperationalHour> operationalHours = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EffectiveHoursOfOperations model) {
            this.date(model.date);
            this.operationalHours(model.operationalHours);
        }

        public final String getDate() {
            return this.date;
        }

        public final void setDate(String date) {
            this.date = date;
        }

        @Override
        public final Builder date(String date) {
            this.date = date;
            return this;
        }

        public final List<OperationalHour.Builder> getOperationalHours() {
            List<OperationalHour.Builder> result = OperationalHoursCopier.copyToBuilder(this.operationalHours);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperationalHours(Collection<OperationalHour.BuilderImpl> operationalHours) {
            this.operationalHours = OperationalHoursCopier.copyFromBuilder(operationalHours);
        }

        @Override
        public final Builder operationalHours(Collection<OperationalHour> operationalHours) {
            this.operationalHours = OperationalHoursCopier.copy(operationalHours);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationalHours(OperationalHour ... operationalHours) {
            this.operationalHours(Arrays.asList(operationalHours));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationalHours(Consumer<OperationalHour.Builder> ... operationalHours) {
            this.operationalHours(Stream.of(operationalHours).map(c -> (OperationalHour)((OperationalHour.Builder)OperationalHour.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EffectiveHoursOfOperations build() {
            return new EffectiveHoursOfOperations(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EffectiveHoursOfOperations> {
        public Builder date(String var1);

        public Builder operationalHours(Collection<OperationalHour> var1);

        public Builder operationalHours(OperationalHour ... var1);

        public Builder operationalHours(Consumer<OperationalHour.Builder> ... var1);
    }
}

