/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.AgentIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AgentsCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AgentsCriteria> {
    private static final SdkField<List<String>> AGENT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AgentIds").getter(AgentsCriteria.getter(AgentsCriteria::agentIds)).setter(AgentsCriteria.setter(Builder::agentIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AgentsCriteria.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> agentIds;

    private AgentsCriteria(BuilderImpl builder) {
        this.agentIds = builder.agentIds;
    }

    public final boolean hasAgentIds() {
        return this.agentIds != null && !(this.agentIds instanceof SdkAutoConstructList);
    }

    public final List<String> agentIds() {
        return this.agentIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentIds() ? this.agentIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentsCriteria)) {
            return false;
        }
        AgentsCriteria other = (AgentsCriteria)obj;
        return this.hasAgentIds() == other.hasAgentIds() && Objects.equals(this.agentIds(), other.agentIds());
    }

    public final String toString() {
        return ToString.builder((String)"AgentsCriteria").add("AgentIds", this.hasAgentIds() ? this.agentIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AgentIds": {
                return Optional.ofNullable(clazz.cast(this.agentIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("AgentIds", AGENT_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgentsCriteria, T> g) {
        return obj -> g.apply((AgentsCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> agentIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AgentsCriteria model) {
            this.agentIds(model.agentIds);
        }

        public final Collection<String> getAgentIds() {
            if (this.agentIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.agentIds;
        }

        public final void setAgentIds(Collection<String> agentIds) {
            this.agentIds = AgentIdsCopier.copy(agentIds);
        }

        @Override
        public final Builder agentIds(Collection<String> agentIds) {
            this.agentIds = AgentIdsCopier.copy(agentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentIds(String ... agentIds) {
            this.agentIds(Arrays.asList(agentIds));
            return this;
        }

        public AgentsCriteria build() {
            return new AgentsCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AgentsCriteria> {
        public Builder agentIds(Collection<String> var1);

        public Builder agentIds(String ... var1);
    }
}

