/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.Attribute;
import software.amazon.awssdk.services.connect.model.ListInstanceAttributesRequest;
import software.amazon.awssdk.services.connect.model.ListInstanceAttributesResponse;

public class ListInstanceAttributesIterable
implements SdkIterable<ListInstanceAttributesResponse> {
    private final ConnectClient client;
    private final ListInstanceAttributesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInstanceAttributesIterable(ConnectClient client, ListInstanceAttributesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInstanceAttributesResponseFetcher();
    }

    public Iterator<ListInstanceAttributesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Attribute> attributes() {
        Function<ListInstanceAttributesResponse, Iterator> getIterator = response -> {
            if (response != null && response.attributes() != null) {
                return response.attributes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInstanceAttributesResponseFetcher
    implements SyncPageFetcher<ListInstanceAttributesResponse> {
        private ListInstanceAttributesResponseFetcher() {
        }

        public boolean hasNextPage(ListInstanceAttributesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInstanceAttributesResponse nextPage(ListInstanceAttributesResponse previousPage) {
            if (previousPage == null) {
                return ListInstanceAttributesIterable.this.client.listInstanceAttributes(ListInstanceAttributesIterable.this.firstRequest);
            }
            return ListInstanceAttributesIterable.this.client.listInstanceAttributes((ListInstanceAttributesRequest)((Object)ListInstanceAttributesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

