/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.SingleSelectOptionsCopier;
import software.amazon.awssdk.services.connect.model.TaskTemplateFieldIdentifier;
import software.amazon.awssdk.services.connect.model.TaskTemplateFieldType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskTemplateField
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskTemplateField> {
    private static final SdkField<TaskTemplateFieldIdentifier> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Id").getter(TaskTemplateField.getter(TaskTemplateField::id)).setter(TaskTemplateField.setter(Builder::id)).constructor(TaskTemplateFieldIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(TaskTemplateField.getter(TaskTemplateField::description)).setter(TaskTemplateField.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(TaskTemplateField.getter(TaskTemplateField::typeAsString)).setter(TaskTemplateField.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<List<String>> SINGLE_SELECT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SingleSelectOptions").getter(TaskTemplateField.getter(TaskTemplateField::singleSelectOptions)).setter(TaskTemplateField.setter(Builder::singleSelectOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleSelectOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, SINGLE_SELECT_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TaskTemplateField.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final TaskTemplateFieldIdentifier id;
    private final String description;
    private final String type;
    private final List<String> singleSelectOptions;

    private TaskTemplateField(BuilderImpl builder) {
        this.id = builder.id;
        this.description = builder.description;
        this.type = builder.type;
        this.singleSelectOptions = builder.singleSelectOptions;
    }

    public final TaskTemplateFieldIdentifier id() {
        return this.id;
    }

    public final String description() {
        return this.description;
    }

    public final TaskTemplateFieldType type() {
        return TaskTemplateFieldType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasSingleSelectOptions() {
        return this.singleSelectOptions != null && !(this.singleSelectOptions instanceof SdkAutoConstructList);
    }

    public final List<String> singleSelectOptions() {
        return this.singleSelectOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSingleSelectOptions() ? this.singleSelectOptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskTemplateField)) {
            return false;
        }
        TaskTemplateField other = (TaskTemplateField)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasSingleSelectOptions() == other.hasSingleSelectOptions() && Objects.equals(this.singleSelectOptions(), other.singleSelectOptions());
    }

    public final String toString() {
        return ToString.builder((String)"TaskTemplateField").add("Id", (Object)this.id()).add("Description", (Object)this.description()).add("Type", (Object)this.typeAsString()).add("SingleSelectOptions", this.hasSingleSelectOptions() ? this.singleSelectOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "SingleSelectOptions": {
                return Optional.ofNullable(clazz.cast(this.singleSelectOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("SingleSelectOptions", SINGLE_SELECT_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaskTemplateField, T> g) {
        return obj -> g.apply((TaskTemplateField)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TaskTemplateFieldIdentifier id;
        private String description;
        private String type;
        private List<String> singleSelectOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TaskTemplateField model) {
            this.id(model.id);
            this.description(model.description);
            this.type(model.type);
            this.singleSelectOptions(model.singleSelectOptions);
        }

        public final TaskTemplateFieldIdentifier.Builder getId() {
            return this.id != null ? this.id.toBuilder() : null;
        }

        public final void setId(TaskTemplateFieldIdentifier.BuilderImpl id) {
            this.id = id != null ? id.build() : null;
        }

        @Override
        public final Builder id(TaskTemplateFieldIdentifier id) {
            this.id = id;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TaskTemplateFieldType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Collection<String> getSingleSelectOptions() {
            if (this.singleSelectOptions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.singleSelectOptions;
        }

        public final void setSingleSelectOptions(Collection<String> singleSelectOptions) {
            this.singleSelectOptions = SingleSelectOptionsCopier.copy(singleSelectOptions);
        }

        @Override
        public final Builder singleSelectOptions(Collection<String> singleSelectOptions) {
            this.singleSelectOptions = SingleSelectOptionsCopier.copy(singleSelectOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder singleSelectOptions(String ... singleSelectOptions) {
            this.singleSelectOptions(Arrays.asList(singleSelectOptions));
            return this;
        }

        public TaskTemplateField build() {
            return new TaskTemplateField(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskTemplateField> {
        public Builder id(TaskTemplateFieldIdentifier var1);

        default public Builder id(Consumer<TaskTemplateFieldIdentifier.Builder> id) {
            return this.id((TaskTemplateFieldIdentifier)((TaskTemplateFieldIdentifier.Builder)TaskTemplateFieldIdentifier.builder().applyMutation(id)).build());
        }

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder type(TaskTemplateFieldType var1);

        public Builder singleSelectOptions(Collection<String> var1);

        public Builder singleSelectOptions(String ... var1);
    }
}

