/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InstanceReplicationStatus {
    INSTANCE_REPLICATION_COMPLETE("INSTANCE_REPLICATION_COMPLETE"),
    INSTANCE_REPLICATION_IN_PROGRESS("INSTANCE_REPLICATION_IN_PROGRESS"),
    INSTANCE_REPLICATION_FAILED("INSTANCE_REPLICATION_FAILED"),
    INSTANCE_REPLICA_DELETING("INSTANCE_REPLICA_DELETING"),
    INSTANCE_REPLICATION_DELETION_FAILED("INSTANCE_REPLICATION_DELETION_FAILED"),
    RESOURCE_REPLICATION_NOT_STARTED("RESOURCE_REPLICATION_NOT_STARTED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InstanceReplicationStatus> VALUE_MAP;
    private final String value;

    private InstanceReplicationStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceReplicationStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceReplicationStatus> knownValues() {
        EnumSet<InstanceReplicationStatus> knownValues = EnumSet.allOf(InstanceReplicationStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InstanceReplicationStatus.class, InstanceReplicationStatus::toString);
    }
}

