/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.AgentConfig;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.SignInConfig;
import software.amazon.awssdk.services.connect.model.TelephonyConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTrafficDistributionRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, UpdateTrafficDistributionRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(UpdateTrafficDistributionRequest.getter(UpdateTrafficDistributionRequest::id)).setter(UpdateTrafficDistributionRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").build()}).build();
    private static final SdkField<TelephonyConfig> TELEPHONY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TelephonyConfig").getter(UpdateTrafficDistributionRequest.getter(UpdateTrafficDistributionRequest::telephonyConfig)).setter(UpdateTrafficDistributionRequest.setter(Builder::telephonyConfig)).constructor(TelephonyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TelephonyConfig").build()}).build();
    private static final SdkField<SignInConfig> SIGN_IN_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SignInConfig").getter(UpdateTrafficDistributionRequest.getter(UpdateTrafficDistributionRequest::signInConfig)).setter(UpdateTrafficDistributionRequest.setter(Builder::signInConfig)).constructor(SignInConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignInConfig").build()}).build();
    private static final SdkField<AgentConfig> AGENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AgentConfig").getter(UpdateTrafficDistributionRequest.getter(UpdateTrafficDistributionRequest::agentConfig)).setter(UpdateTrafficDistributionRequest.setter(Builder::agentConfig)).constructor(AgentConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TELEPHONY_CONFIG_FIELD, SIGN_IN_CONFIG_FIELD, AGENT_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("TelephonyConfig", TELEPHONY_CONFIG_FIELD);
            this.put("SignInConfig", SIGN_IN_CONFIG_FIELD);
            this.put("AgentConfig", AGENT_CONFIG_FIELD);
        }
    });
    private final String id;
    private final TelephonyConfig telephonyConfig;
    private final SignInConfig signInConfig;
    private final AgentConfig agentConfig;

    private UpdateTrafficDistributionRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.telephonyConfig = builder.telephonyConfig;
        this.signInConfig = builder.signInConfig;
        this.agentConfig = builder.agentConfig;
    }

    public final String id() {
        return this.id;
    }

    public final TelephonyConfig telephonyConfig() {
        return this.telephonyConfig;
    }

    public final SignInConfig signInConfig() {
        return this.signInConfig;
    }

    public final AgentConfig agentConfig() {
        return this.agentConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.telephonyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.signInConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrafficDistributionRequest)) {
            return false;
        }
        UpdateTrafficDistributionRequest other = (UpdateTrafficDistributionRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.telephonyConfig(), other.telephonyConfig()) && Objects.equals(this.signInConfig(), other.signInConfig()) && Objects.equals(this.agentConfig(), other.agentConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTrafficDistributionRequest").add("Id", (Object)this.id()).add("TelephonyConfig", (Object)this.telephonyConfig()).add("SignInConfig", (Object)this.signInConfig()).add("AgentConfig", (Object)this.agentConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "TelephonyConfig": {
                return Optional.ofNullable(clazz.cast(this.telephonyConfig()));
            }
            case "SignInConfig": {
                return Optional.ofNullable(clazz.cast(this.signInConfig()));
            }
            case "AgentConfig": {
                return Optional.ofNullable(clazz.cast(this.agentConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTrafficDistributionRequest, T> g) {
        return obj -> g.apply((UpdateTrafficDistributionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String id;
        private TelephonyConfig telephonyConfig;
        private SignInConfig signInConfig;
        private AgentConfig agentConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrafficDistributionRequest model) {
            super(model);
            this.id(model.id);
            this.telephonyConfig(model.telephonyConfig);
            this.signInConfig(model.signInConfig);
            this.agentConfig(model.agentConfig);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final TelephonyConfig.Builder getTelephonyConfig() {
            return this.telephonyConfig != null ? this.telephonyConfig.toBuilder() : null;
        }

        public final void setTelephonyConfig(TelephonyConfig.BuilderImpl telephonyConfig) {
            this.telephonyConfig = telephonyConfig != null ? telephonyConfig.build() : null;
        }

        @Override
        public final Builder telephonyConfig(TelephonyConfig telephonyConfig) {
            this.telephonyConfig = telephonyConfig;
            return this;
        }

        public final SignInConfig.Builder getSignInConfig() {
            return this.signInConfig != null ? this.signInConfig.toBuilder() : null;
        }

        public final void setSignInConfig(SignInConfig.BuilderImpl signInConfig) {
            this.signInConfig = signInConfig != null ? signInConfig.build() : null;
        }

        @Override
        public final Builder signInConfig(SignInConfig signInConfig) {
            this.signInConfig = signInConfig;
            return this;
        }

        public final AgentConfig.Builder getAgentConfig() {
            return this.agentConfig != null ? this.agentConfig.toBuilder() : null;
        }

        public final void setAgentConfig(AgentConfig.BuilderImpl agentConfig) {
            this.agentConfig = agentConfig != null ? agentConfig.build() : null;
        }

        @Override
        public final Builder agentConfig(AgentConfig agentConfig) {
            this.agentConfig = agentConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTrafficDistributionRequest build() {
            return new UpdateTrafficDistributionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTrafficDistributionRequest> {
        public Builder id(String var1);

        public Builder telephonyConfig(TelephonyConfig var1);

        default public Builder telephonyConfig(Consumer<TelephonyConfig.Builder> telephonyConfig) {
            return this.telephonyConfig((TelephonyConfig)((TelephonyConfig.Builder)TelephonyConfig.builder().applyMutation(telephonyConfig)).build());
        }

        public Builder signInConfig(SignInConfig var1);

        default public Builder signInConfig(Consumer<SignInConfig.Builder> signInConfig) {
            return this.signInConfig((SignInConfig)((SignInConfig.Builder)SignInConfig.builder().applyMutation(signInConfig)).build());
        }

        public Builder agentConfig(AgentConfig var1);

        default public Builder agentConfig(Consumer<AgentConfig.Builder> agentConfig) {
            return this.agentConfig((AgentConfig)((AgentConfig.Builder)AgentConfig.builder().applyMutation(agentConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

