/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.CreatedByInfo;
import software.amazon.awssdk.services.connect.model.FileStatusType;
import software.amazon.awssdk.services.connect.model.UploadUrlMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartAttachedFileUploadResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, StartAttachedFileUploadResponse> {
    private static final SdkField<String> FILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileArn").getter(StartAttachedFileUploadResponse.getter(StartAttachedFileUploadResponse::fileArn)).setter(StartAttachedFileUploadResponse.setter(Builder::fileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileArn").build()}).build();
    private static final SdkField<String> FILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileId").getter(StartAttachedFileUploadResponse.getter(StartAttachedFileUploadResponse::fileId)).setter(StartAttachedFileUploadResponse.setter(Builder::fileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileId").build()}).build();
    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationTime").getter(StartAttachedFileUploadResponse.getter(StartAttachedFileUploadResponse::creationTime)).setter(StartAttachedFileUploadResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> FILE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileStatus").getter(StartAttachedFileUploadResponse.getter(StartAttachedFileUploadResponse::fileStatusAsString)).setter(StartAttachedFileUploadResponse.setter(Builder::fileStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileStatus").build()}).build();
    private static final SdkField<CreatedByInfo> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedBy").getter(StartAttachedFileUploadResponse.getter(StartAttachedFileUploadResponse::createdBy)).setter(StartAttachedFileUploadResponse.setter(Builder::createdBy)).constructor(CreatedByInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<UploadUrlMetadata> UPLOAD_URL_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UploadUrlMetadata").getter(StartAttachedFileUploadResponse.getter(StartAttachedFileUploadResponse::uploadUrlMetadata)).setter(StartAttachedFileUploadResponse.setter(Builder::uploadUrlMetadata)).constructor(UploadUrlMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadUrlMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_ARN_FIELD, FILE_ID_FIELD, CREATION_TIME_FIELD, FILE_STATUS_FIELD, CREATED_BY_FIELD, UPLOAD_URL_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FileArn", FILE_ARN_FIELD);
            this.put("FileId", FILE_ID_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("FileStatus", FILE_STATUS_FIELD);
            this.put("CreatedBy", CREATED_BY_FIELD);
            this.put("UploadUrlMetadata", UPLOAD_URL_METADATA_FIELD);
        }
    });
    private final String fileArn;
    private final String fileId;
    private final String creationTime;
    private final String fileStatus;
    private final CreatedByInfo createdBy;
    private final UploadUrlMetadata uploadUrlMetadata;

    private StartAttachedFileUploadResponse(BuilderImpl builder) {
        super(builder);
        this.fileArn = builder.fileArn;
        this.fileId = builder.fileId;
        this.creationTime = builder.creationTime;
        this.fileStatus = builder.fileStatus;
        this.createdBy = builder.createdBy;
        this.uploadUrlMetadata = builder.uploadUrlMetadata;
    }

    public final String fileArn() {
        return this.fileArn;
    }

    public final String fileId() {
        return this.fileId;
    }

    public final String creationTime() {
        return this.creationTime;
    }

    public final FileStatusType fileStatus() {
        return FileStatusType.fromValue(this.fileStatus);
    }

    public final String fileStatusAsString() {
        return this.fileStatus;
    }

    public final CreatedByInfo createdBy() {
        return this.createdBy;
    }

    public final UploadUrlMetadata uploadUrlMetadata() {
        return this.uploadUrlMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadUrlMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAttachedFileUploadResponse)) {
            return false;
        }
        StartAttachedFileUploadResponse other = (StartAttachedFileUploadResponse)((Object)obj);
        return Objects.equals(this.fileArn(), other.fileArn()) && Objects.equals(this.fileId(), other.fileId()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.fileStatusAsString(), other.fileStatusAsString()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.uploadUrlMetadata(), other.uploadUrlMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"StartAttachedFileUploadResponse").add("FileArn", (Object)this.fileArn()).add("FileId", (Object)this.fileId()).add("CreationTime", (Object)this.creationTime()).add("FileStatus", (Object)this.fileStatusAsString()).add("CreatedBy", (Object)this.createdBy()).add("UploadUrlMetadata", (Object)this.uploadUrlMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileArn": {
                return Optional.ofNullable(clazz.cast(this.fileArn()));
            }
            case "FileId": {
                return Optional.ofNullable(clazz.cast(this.fileId()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "FileStatus": {
                return Optional.ofNullable(clazz.cast(this.fileStatusAsString()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "UploadUrlMetadata": {
                return Optional.ofNullable(clazz.cast(this.uploadUrlMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartAttachedFileUploadResponse, T> g) {
        return obj -> g.apply((StartAttachedFileUploadResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String fileArn;
        private String fileId;
        private String creationTime;
        private String fileStatus;
        private CreatedByInfo createdBy;
        private UploadUrlMetadata uploadUrlMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAttachedFileUploadResponse model) {
            super(model);
            this.fileArn(model.fileArn);
            this.fileId(model.fileId);
            this.creationTime(model.creationTime);
            this.fileStatus(model.fileStatus);
            this.createdBy(model.createdBy);
            this.uploadUrlMetadata(model.uploadUrlMetadata);
        }

        public final String getFileArn() {
            return this.fileArn;
        }

        public final void setFileArn(String fileArn) {
            this.fileArn = fileArn;
        }

        @Override
        public final Builder fileArn(String fileArn) {
            this.fileArn = fileArn;
            return this;
        }

        public final String getFileId() {
            return this.fileId;
        }

        public final void setFileId(String fileId) {
            this.fileId = fileId;
        }

        @Override
        public final Builder fileId(String fileId) {
            this.fileId = fileId;
            return this;
        }

        public final String getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFileStatus() {
            return this.fileStatus;
        }

        public final void setFileStatus(String fileStatus) {
            this.fileStatus = fileStatus;
        }

        @Override
        public final Builder fileStatus(String fileStatus) {
            this.fileStatus = fileStatus;
            return this;
        }

        @Override
        public final Builder fileStatus(FileStatusType fileStatus) {
            this.fileStatus(fileStatus == null ? null : fileStatus.toString());
            return this;
        }

        public final CreatedByInfo.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(CreatedByInfo.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(CreatedByInfo createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final UploadUrlMetadata.Builder getUploadUrlMetadata() {
            return this.uploadUrlMetadata != null ? this.uploadUrlMetadata.toBuilder() : null;
        }

        public final void setUploadUrlMetadata(UploadUrlMetadata.BuilderImpl uploadUrlMetadata) {
            this.uploadUrlMetadata = uploadUrlMetadata != null ? uploadUrlMetadata.build() : null;
        }

        @Override
        public final Builder uploadUrlMetadata(UploadUrlMetadata uploadUrlMetadata) {
            this.uploadUrlMetadata = uploadUrlMetadata;
            return this;
        }

        @Override
        public StartAttachedFileUploadResponse build() {
            return new StartAttachedFileUploadResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartAttachedFileUploadResponse> {
        public Builder fileArn(String var1);

        public Builder fileId(String var1);

        public Builder creationTime(String var1);

        public Builder fileStatus(String var1);

        public Builder fileStatus(FileStatusType var1);

        public Builder createdBy(CreatedByInfo var1);

        default public Builder createdBy(Consumer<CreatedByInfo.Builder> createdBy) {
            return this.createdBy((CreatedByInfo)((CreatedByInfo.Builder)CreatedByInfo.builder().applyMutation(createdBy)).build());
        }

        public Builder uploadUrlMetadata(UploadUrlMetadata var1);

        default public Builder uploadUrlMetadata(Consumer<UploadUrlMetadata.Builder> uploadUrlMetadata) {
            return this.uploadUrlMetadata((UploadUrlMetadata)((UploadUrlMetadata.Builder)UploadUrlMetadata.builder().applyMutation(uploadUrlMetadata)).build());
        }
    }
}

