/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ParticipantRole;
import software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisAttachment;
import software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisAttachmentsCopier;
import software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisTimeData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RealTimeContactAnalysisSegmentAttachments
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RealTimeContactAnalysisSegmentAttachments> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(RealTimeContactAnalysisSegmentAttachments.getter(RealTimeContactAnalysisSegmentAttachments::id)).setter(RealTimeContactAnalysisSegmentAttachments.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParticipantId").getter(RealTimeContactAnalysisSegmentAttachments.getter(RealTimeContactAnalysisSegmentAttachments::participantId)).setter(RealTimeContactAnalysisSegmentAttachments.setter(Builder::participantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantId").build()}).build();
    private static final SdkField<String> PARTICIPANT_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParticipantRole").getter(RealTimeContactAnalysisSegmentAttachments.getter(RealTimeContactAnalysisSegmentAttachments::participantRoleAsString)).setter(RealTimeContactAnalysisSegmentAttachments.setter(Builder::participantRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantRole").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(RealTimeContactAnalysisSegmentAttachments.getter(RealTimeContactAnalysisSegmentAttachments::displayName)).setter(RealTimeContactAnalysisSegmentAttachments.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<List<RealTimeContactAnalysisAttachment>> ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attachments").getter(RealTimeContactAnalysisSegmentAttachments.getter(RealTimeContactAnalysisSegmentAttachments::attachments)).setter(RealTimeContactAnalysisSegmentAttachments.setter(Builder::attachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RealTimeContactAnalysisAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RealTimeContactAnalysisTimeData> TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Time").getter(RealTimeContactAnalysisSegmentAttachments.getter(RealTimeContactAnalysisSegmentAttachments::time)).setter(RealTimeContactAnalysisSegmentAttachments.setter(Builder::time)).constructor(RealTimeContactAnalysisTimeData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Time").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, PARTICIPANT_ID_FIELD, PARTICIPANT_ROLE_FIELD, DISPLAY_NAME_FIELD, ATTACHMENTS_FIELD, TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("ParticipantId", PARTICIPANT_ID_FIELD);
            this.put("ParticipantRole", PARTICIPANT_ROLE_FIELD);
            this.put("DisplayName", DISPLAY_NAME_FIELD);
            this.put("Attachments", ATTACHMENTS_FIELD);
            this.put("Time", TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String participantId;
    private final String participantRole;
    private final String displayName;
    private final List<RealTimeContactAnalysisAttachment> attachments;
    private final RealTimeContactAnalysisTimeData time;

    private RealTimeContactAnalysisSegmentAttachments(BuilderImpl builder) {
        this.id = builder.id;
        this.participantId = builder.participantId;
        this.participantRole = builder.participantRole;
        this.displayName = builder.displayName;
        this.attachments = builder.attachments;
        this.time = builder.time;
    }

    public final String id() {
        return this.id;
    }

    public final String participantId() {
        return this.participantId;
    }

    public final ParticipantRole participantRole() {
        return ParticipantRole.fromValue(this.participantRole);
    }

    public final String participantRoleAsString() {
        return this.participantRole;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final boolean hasAttachments() {
        return this.attachments != null && !(this.attachments instanceof SdkAutoConstructList);
    }

    public final List<RealTimeContactAnalysisAttachment> attachments() {
        return this.attachments;
    }

    public final RealTimeContactAnalysisTimeData time() {
        return this.time;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachments() ? this.attachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.time());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealTimeContactAnalysisSegmentAttachments)) {
            return false;
        }
        RealTimeContactAnalysisSegmentAttachments other = (RealTimeContactAnalysisSegmentAttachments)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.participantId(), other.participantId()) && Objects.equals(this.participantRoleAsString(), other.participantRoleAsString()) && Objects.equals(this.displayName(), other.displayName()) && this.hasAttachments() == other.hasAttachments() && Objects.equals(this.attachments(), other.attachments()) && Objects.equals(this.time(), other.time());
    }

    public final String toString() {
        return ToString.builder((String)"RealTimeContactAnalysisSegmentAttachments").add("Id", (Object)this.id()).add("ParticipantId", (Object)this.participantId()).add("ParticipantRole", (Object)this.participantRoleAsString()).add("DisplayName", (Object)this.displayName()).add("Attachments", this.hasAttachments() ? this.attachments() : null).add("Time", (Object)this.time()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ParticipantId": {
                return Optional.ofNullable(clazz.cast(this.participantId()));
            }
            case "ParticipantRole": {
                return Optional.ofNullable(clazz.cast(this.participantRoleAsString()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "Attachments": {
                return Optional.ofNullable(clazz.cast(this.attachments()));
            }
            case "Time": {
                return Optional.ofNullable(clazz.cast(this.time()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RealTimeContactAnalysisSegmentAttachments, T> g) {
        return obj -> g.apply((RealTimeContactAnalysisSegmentAttachments)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String participantId;
        private String participantRole;
        private String displayName;
        private List<RealTimeContactAnalysisAttachment> attachments = DefaultSdkAutoConstructList.getInstance();
        private RealTimeContactAnalysisTimeData time;

        private BuilderImpl() {
        }

        private BuilderImpl(RealTimeContactAnalysisSegmentAttachments model) {
            this.id(model.id);
            this.participantId(model.participantId);
            this.participantRole(model.participantRole);
            this.displayName(model.displayName);
            this.attachments(model.attachments);
            this.time(model.time);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getParticipantId() {
            return this.participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final String getParticipantRole() {
            return this.participantRole;
        }

        public final void setParticipantRole(String participantRole) {
            this.participantRole = participantRole;
        }

        @Override
        public final Builder participantRole(String participantRole) {
            this.participantRole = participantRole;
            return this;
        }

        @Override
        public final Builder participantRole(ParticipantRole participantRole) {
            this.participantRole(participantRole == null ? null : participantRole.toString());
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final List<RealTimeContactAnalysisAttachment.Builder> getAttachments() {
            List<RealTimeContactAnalysisAttachment.Builder> result = RealTimeContactAnalysisAttachmentsCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<RealTimeContactAnalysisAttachment.BuilderImpl> attachments) {
            this.attachments = RealTimeContactAnalysisAttachmentsCopier.copyFromBuilder(attachments);
        }

        @Override
        public final Builder attachments(Collection<RealTimeContactAnalysisAttachment> attachments) {
            this.attachments = RealTimeContactAnalysisAttachmentsCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(RealTimeContactAnalysisAttachment ... attachments) {
            this.attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<RealTimeContactAnalysisAttachment.Builder> ... attachments) {
            this.attachments(Stream.of(attachments).map(c -> (RealTimeContactAnalysisAttachment)((RealTimeContactAnalysisAttachment.Builder)RealTimeContactAnalysisAttachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final RealTimeContactAnalysisTimeData.Builder getTime() {
            return this.time != null ? this.time.toBuilder() : null;
        }

        public final void setTime(RealTimeContactAnalysisTimeData.BuilderImpl time) {
            this.time = time != null ? time.build() : null;
        }

        @Override
        public final Builder time(RealTimeContactAnalysisTimeData time) {
            this.time = time;
            return this;
        }

        public RealTimeContactAnalysisSegmentAttachments build() {
            return new RealTimeContactAnalysisSegmentAttachments(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RealTimeContactAnalysisSegmentAttachments> {
        public Builder id(String var1);

        public Builder participantId(String var1);

        public Builder participantRole(String var1);

        public Builder participantRole(ParticipantRole var1);

        public Builder displayName(String var1);

        public Builder attachments(Collection<RealTimeContactAnalysisAttachment> var1);

        public Builder attachments(RealTimeContactAnalysisAttachment ... var1);

        public Builder attachments(Consumer<RealTimeContactAnalysisAttachment.Builder> ... var1);

        public Builder time(RealTimeContactAnalysisTimeData var1);

        default public Builder time(Consumer<RealTimeContactAnalysisTimeData.Builder> time) {
            return this.time((RealTimeContactAnalysisTimeData)((RealTimeContactAnalysisTimeData.Builder)RealTimeContactAnalysisTimeData.builder().applyMutation(time)).build());
        }
    }
}

