/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.CurrentMetricResult;
import software.amazon.awssdk.services.connect.model.CurrentMetricResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCurrentMetricDataResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, GetCurrentMetricDataResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetCurrentMetricDataResponse.getter(GetCurrentMetricDataResponse::nextToken)).setter(GetCurrentMetricDataResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<CurrentMetricResult>> METRIC_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricResults").getter(GetCurrentMetricDataResponse.getter(GetCurrentMetricDataResponse::metricResults)).setter(GetCurrentMetricDataResponse.setter(Builder::metricResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CurrentMetricResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> DATA_SNAPSHOT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DataSnapshotTime").getter(GetCurrentMetricDataResponse.getter(GetCurrentMetricDataResponse::dataSnapshotTime)).setter(GetCurrentMetricDataResponse.setter(Builder::dataSnapshotTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSnapshotTime").build()}).build();
    private static final SdkField<Long> APPROXIMATE_TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApproximateTotalCount").getter(GetCurrentMetricDataResponse.getter(GetCurrentMetricDataResponse::approximateTotalCount)).setter(GetCurrentMetricDataResponse.setter(Builder::approximateTotalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateTotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, METRIC_RESULTS_FIELD, DATA_SNAPSHOT_TIME_FIELD, APPROXIMATE_TOTAL_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("MetricResults", METRIC_RESULTS_FIELD);
            this.put("DataSnapshotTime", DATA_SNAPSHOT_TIME_FIELD);
            this.put("ApproximateTotalCount", APPROXIMATE_TOTAL_COUNT_FIELD);
        }
    });
    private final String nextToken;
    private final List<CurrentMetricResult> metricResults;
    private final Instant dataSnapshotTime;
    private final Long approximateTotalCount;

    private GetCurrentMetricDataResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.metricResults = builder.metricResults;
        this.dataSnapshotTime = builder.dataSnapshotTime;
        this.approximateTotalCount = builder.approximateTotalCount;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasMetricResults() {
        return this.metricResults != null && !(this.metricResults instanceof SdkAutoConstructList);
    }

    public final List<CurrentMetricResult> metricResults() {
        return this.metricResults;
    }

    public final Instant dataSnapshotTime() {
        return this.dataSnapshotTime;
    }

    public final Long approximateTotalCount() {
        return this.approximateTotalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricResults() ? this.metricResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSnapshotTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateTotalCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCurrentMetricDataResponse)) {
            return false;
        }
        GetCurrentMetricDataResponse other = (GetCurrentMetricDataResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasMetricResults() == other.hasMetricResults() && Objects.equals(this.metricResults(), other.metricResults()) && Objects.equals(this.dataSnapshotTime(), other.dataSnapshotTime()) && Objects.equals(this.approximateTotalCount(), other.approximateTotalCount());
    }

    public final String toString() {
        return ToString.builder((String)"GetCurrentMetricDataResponse").add("NextToken", (Object)this.nextToken()).add("MetricResults", this.hasMetricResults() ? this.metricResults() : null).add("DataSnapshotTime", (Object)this.dataSnapshotTime()).add("ApproximateTotalCount", (Object)this.approximateTotalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MetricResults": {
                return Optional.ofNullable(clazz.cast(this.metricResults()));
            }
            case "DataSnapshotTime": {
                return Optional.ofNullable(clazz.cast(this.dataSnapshotTime()));
            }
            case "ApproximateTotalCount": {
                return Optional.ofNullable(clazz.cast(this.approximateTotalCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetCurrentMetricDataResponse, T> g) {
        return obj -> g.apply((GetCurrentMetricDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CurrentMetricResult> metricResults = DefaultSdkAutoConstructList.getInstance();
        private Instant dataSnapshotTime;
        private Long approximateTotalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCurrentMetricDataResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.metricResults(model.metricResults);
            this.dataSnapshotTime(model.dataSnapshotTime);
            this.approximateTotalCount(model.approximateTotalCount);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CurrentMetricResult.Builder> getMetricResults() {
            List<CurrentMetricResult.Builder> result = CurrentMetricResultsCopier.copyToBuilder(this.metricResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricResults(Collection<CurrentMetricResult.BuilderImpl> metricResults) {
            this.metricResults = CurrentMetricResultsCopier.copyFromBuilder(metricResults);
        }

        @Override
        public final Builder metricResults(Collection<CurrentMetricResult> metricResults) {
            this.metricResults = CurrentMetricResultsCopier.copy(metricResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricResults(CurrentMetricResult ... metricResults) {
            this.metricResults(Arrays.asList(metricResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricResults(Consumer<CurrentMetricResult.Builder> ... metricResults) {
            this.metricResults(Stream.of(metricResults).map(c -> (CurrentMetricResult)((CurrentMetricResult.Builder)CurrentMetricResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getDataSnapshotTime() {
            return this.dataSnapshotTime;
        }

        public final void setDataSnapshotTime(Instant dataSnapshotTime) {
            this.dataSnapshotTime = dataSnapshotTime;
        }

        @Override
        public final Builder dataSnapshotTime(Instant dataSnapshotTime) {
            this.dataSnapshotTime = dataSnapshotTime;
            return this;
        }

        public final Long getApproximateTotalCount() {
            return this.approximateTotalCount;
        }

        public final void setApproximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
        }

        @Override
        public final Builder approximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
            return this;
        }

        @Override
        public GetCurrentMetricDataResponse build() {
            return new GetCurrentMetricDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCurrentMetricDataResponse> {
        public Builder nextToken(String var1);

        public Builder metricResults(Collection<CurrentMetricResult> var1);

        public Builder metricResults(CurrentMetricResult ... var1);

        public Builder metricResults(Consumer<CurrentMetricResult.Builder> ... var1);

        public Builder dataSnapshotTime(Instant var1);

        public Builder approximateTotalCount(Long var1);
    }
}

