/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationScore
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationScore> {
    private static final SdkField<Double> PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Percentage").getter(EvaluationScore.getter(EvaluationScore::percentage)).setter(EvaluationScore.setter(Builder::percentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Percentage").build()}).build();
    private static final SdkField<Boolean> NOT_APPLICABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NotApplicable").getter(EvaluationScore.getter(EvaluationScore::notApplicable)).setter(EvaluationScore.setter(Builder::notApplicable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotApplicable").build()}).build();
    private static final SdkField<Boolean> AUTOMATIC_FAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutomaticFail").getter(EvaluationScore.getter(EvaluationScore::automaticFail)).setter(EvaluationScore.setter(Builder::automaticFail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticFail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERCENTAGE_FIELD, NOT_APPLICABLE_FIELD, AUTOMATIC_FAIL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Percentage", PERCENTAGE_FIELD);
            this.put("NotApplicable", NOT_APPLICABLE_FIELD);
            this.put("AutomaticFail", AUTOMATIC_FAIL_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Double percentage;
    private final Boolean notApplicable;
    private final Boolean automaticFail;

    private EvaluationScore(BuilderImpl builder) {
        this.percentage = builder.percentage;
        this.notApplicable = builder.notApplicable;
        this.automaticFail = builder.automaticFail;
    }

    public final Double percentage() {
        return this.percentage;
    }

    public final Boolean notApplicable() {
        return this.notApplicable;
    }

    public final Boolean automaticFail() {
        return this.automaticFail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.percentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.notApplicable());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticFail());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationScore)) {
            return false;
        }
        EvaluationScore other = (EvaluationScore)obj;
        return Objects.equals(this.percentage(), other.percentage()) && Objects.equals(this.notApplicable(), other.notApplicable()) && Objects.equals(this.automaticFail(), other.automaticFail());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationScore").add("Percentage", (Object)this.percentage()).add("NotApplicable", (Object)this.notApplicable()).add("AutomaticFail", (Object)this.automaticFail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Percentage": {
                return Optional.ofNullable(clazz.cast(this.percentage()));
            }
            case "NotApplicable": {
                return Optional.ofNullable(clazz.cast(this.notApplicable()));
            }
            case "AutomaticFail": {
                return Optional.ofNullable(clazz.cast(this.automaticFail()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EvaluationScore, T> g) {
        return obj -> g.apply((EvaluationScore)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double percentage;
        private Boolean notApplicable;
        private Boolean automaticFail;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationScore model) {
            this.percentage(model.percentage);
            this.notApplicable(model.notApplicable);
            this.automaticFail(model.automaticFail);
        }

        public final Double getPercentage() {
            return this.percentage;
        }

        public final void setPercentage(Double percentage) {
            this.percentage = percentage;
        }

        @Override
        public final Builder percentage(Double percentage) {
            this.percentage = percentage;
            return this;
        }

        public final Boolean getNotApplicable() {
            return this.notApplicable;
        }

        public final void setNotApplicable(Boolean notApplicable) {
            this.notApplicable = notApplicable;
        }

        @Override
        public final Builder notApplicable(Boolean notApplicable) {
            this.notApplicable = notApplicable;
            return this;
        }

        public final Boolean getAutomaticFail() {
            return this.automaticFail;
        }

        public final void setAutomaticFail(Boolean automaticFail) {
            this.automaticFail = automaticFail;
        }

        @Override
        public final Builder automaticFail(Boolean automaticFail) {
            this.automaticFail = automaticFail;
            return this;
        }

        public EvaluationScore build() {
            return new EvaluationScore(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationScore> {
        public Builder percentage(Double var1);

        public Builder notApplicable(Boolean var1);

        public Builder automaticFail(Boolean var1);
    }
}

