/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.HierarchyGroupCondition;
import software.amazon.awssdk.services.connect.model.TagAndConditionListCopier;
import software.amazon.awssdk.services.connect.model.TagCondition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttributeAndCondition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AttributeAndCondition> {
    private static final SdkField<List<TagCondition>> TAG_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagConditions").getter(AttributeAndCondition.getter(AttributeAndCondition::tagConditions)).setter(AttributeAndCondition.setter(Builder::tagConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<HierarchyGroupCondition> HIERARCHY_GROUP_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HierarchyGroupCondition").getter(AttributeAndCondition.getter(AttributeAndCondition::hierarchyGroupCondition)).setter(AttributeAndCondition.setter(Builder::hierarchyGroupCondition)).constructor(HierarchyGroupCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchyGroupCondition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_CONDITIONS_FIELD, HIERARCHY_GROUP_CONDITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TagConditions", TAG_CONDITIONS_FIELD);
            this.put("HierarchyGroupCondition", HIERARCHY_GROUP_CONDITION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<TagCondition> tagConditions;
    private final HierarchyGroupCondition hierarchyGroupCondition;

    private AttributeAndCondition(BuilderImpl builder) {
        this.tagConditions = builder.tagConditions;
        this.hierarchyGroupCondition = builder.hierarchyGroupCondition;
    }

    public final boolean hasTagConditions() {
        return this.tagConditions != null && !(this.tagConditions instanceof SdkAutoConstructList);
    }

    public final List<TagCondition> tagConditions() {
        return this.tagConditions;
    }

    public final HierarchyGroupCondition hierarchyGroupCondition() {
        return this.hierarchyGroupCondition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagConditions() ? this.tagConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hierarchyGroupCondition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeAndCondition)) {
            return false;
        }
        AttributeAndCondition other = (AttributeAndCondition)obj;
        return this.hasTagConditions() == other.hasTagConditions() && Objects.equals(this.tagConditions(), other.tagConditions()) && Objects.equals(this.hierarchyGroupCondition(), other.hierarchyGroupCondition());
    }

    public final String toString() {
        return ToString.builder((String)"AttributeAndCondition").add("TagConditions", this.hasTagConditions() ? this.tagConditions() : null).add("HierarchyGroupCondition", (Object)this.hierarchyGroupCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TagConditions": {
                return Optional.ofNullable(clazz.cast(this.tagConditions()));
            }
            case "HierarchyGroupCondition": {
                return Optional.ofNullable(clazz.cast(this.hierarchyGroupCondition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AttributeAndCondition, T> g) {
        return obj -> g.apply((AttributeAndCondition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<TagCondition> tagConditions = DefaultSdkAutoConstructList.getInstance();
        private HierarchyGroupCondition hierarchyGroupCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeAndCondition model) {
            this.tagConditions(model.tagConditions);
            this.hierarchyGroupCondition(model.hierarchyGroupCondition);
        }

        public final List<TagCondition.Builder> getTagConditions() {
            List<TagCondition.Builder> result = TagAndConditionListCopier.copyToBuilder(this.tagConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagConditions(Collection<TagCondition.BuilderImpl> tagConditions) {
            this.tagConditions = TagAndConditionListCopier.copyFromBuilder(tagConditions);
        }

        @Override
        public final Builder tagConditions(Collection<TagCondition> tagConditions) {
            this.tagConditions = TagAndConditionListCopier.copy(tagConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagConditions(TagCondition ... tagConditions) {
            this.tagConditions(Arrays.asList(tagConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagConditions(Consumer<TagCondition.Builder> ... tagConditions) {
            this.tagConditions(Stream.of(tagConditions).map(c -> (TagCondition)((TagCondition.Builder)TagCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final HierarchyGroupCondition.Builder getHierarchyGroupCondition() {
            return this.hierarchyGroupCondition != null ? this.hierarchyGroupCondition.toBuilder() : null;
        }

        public final void setHierarchyGroupCondition(HierarchyGroupCondition.BuilderImpl hierarchyGroupCondition) {
            this.hierarchyGroupCondition = hierarchyGroupCondition != null ? hierarchyGroupCondition.build() : null;
        }

        @Override
        public final Builder hierarchyGroupCondition(HierarchyGroupCondition hierarchyGroupCondition) {
            this.hierarchyGroupCondition = hierarchyGroupCondition;
            return this;
        }

        public AttributeAndCondition build() {
            return new AttributeAndCondition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AttributeAndCondition> {
        public Builder tagConditions(Collection<TagCondition> var1);

        public Builder tagConditions(TagCondition ... var1);

        public Builder tagConditions(Consumer<TagCondition.Builder> ... var1);

        public Builder hierarchyGroupCondition(HierarchyGroupCondition var1);

        default public Builder hierarchyGroupCondition(Consumer<HierarchyGroupCondition.Builder> hierarchyGroupCondition) {
            return this.hierarchyGroupCondition((HierarchyGroupCondition)((HierarchyGroupCondition.Builder)HierarchyGroupCondition.builder().applyMutation(hierarchyGroupCondition)).build());
        }
    }
}

