/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IntegrationType {
    EVENT("EVENT"),
    VOICE_ID("VOICE_ID"),
    PINPOINT_APP("PINPOINT_APP"),
    WISDOM_ASSISTANT("WISDOM_ASSISTANT"),
    WISDOM_KNOWLEDGE_BASE("WISDOM_KNOWLEDGE_BASE"),
    WISDOM_QUICK_RESPONSES("WISDOM_QUICK_RESPONSES"),
    Q_MESSAGE_TEMPLATES("Q_MESSAGE_TEMPLATES"),
    CASES_DOMAIN("CASES_DOMAIN"),
    APPLICATION("APPLICATION"),
    FILE_SCANNER("FILE_SCANNER"),
    SES_IDENTITY("SES_IDENTITY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IntegrationType> VALUE_MAP;
    private final String value;

    private IntegrationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IntegrationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IntegrationType> knownValues() {
        EnumSet<IntegrationType> knownValues = EnumSet.allOf(IntegrationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IntegrationType.class, IntegrationType::toString);
    }
}

