/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.InstanceStorageConfig;
import software.amazon.awssdk.services.connect.model.InstanceStorageResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateInstanceStorageConfigRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, UpdateInstanceStorageConfigRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(UpdateInstanceStorageConfigRequest.getter(UpdateInstanceStorageConfigRequest::instanceId)).setter(UpdateInstanceStorageConfigRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationId").getter(UpdateInstanceStorageConfigRequest.getter(UpdateInstanceStorageConfigRequest::associationId)).setter(UpdateInstanceStorageConfigRequest.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AssociationId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(UpdateInstanceStorageConfigRequest.getter(UpdateInstanceStorageConfigRequest::resourceTypeAsString)).setter(UpdateInstanceStorageConfigRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceType").build()}).build();
    private static final SdkField<InstanceStorageConfig> STORAGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StorageConfig").getter(UpdateInstanceStorageConfigRequest.getter(UpdateInstanceStorageConfigRequest::storageConfig)).setter(UpdateInstanceStorageConfigRequest.setter(Builder::storageConfig)).constructor(InstanceStorageConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, ASSOCIATION_ID_FIELD, RESOURCE_TYPE_FIELD, STORAGE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InstanceId", INSTANCE_ID_FIELD);
            this.put("AssociationId", ASSOCIATION_ID_FIELD);
            this.put("resourceType", RESOURCE_TYPE_FIELD);
            this.put("StorageConfig", STORAGE_CONFIG_FIELD);
        }
    });
    private final String instanceId;
    private final String associationId;
    private final String resourceType;
    private final InstanceStorageConfig storageConfig;

    private UpdateInstanceStorageConfigRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.associationId = builder.associationId;
        this.resourceType = builder.resourceType;
        this.storageConfig = builder.storageConfig;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final InstanceStorageResourceType resourceType() {
        return InstanceStorageResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final InstanceStorageConfig storageConfig() {
        return this.storageConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInstanceStorageConfigRequest)) {
            return false;
        }
        UpdateInstanceStorageConfigRequest other = (UpdateInstanceStorageConfigRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.storageConfig(), other.storageConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateInstanceStorageConfigRequest").add("InstanceId", (Object)this.instanceId()).add("AssociationId", (Object)this.associationId()).add("ResourceType", (Object)this.resourceTypeAsString()).add("StorageConfig", (Object)this.storageConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "StorageConfig": {
                return Optional.ofNullable(clazz.cast(this.storageConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateInstanceStorageConfigRequest, T> g) {
        return obj -> g.apply((UpdateInstanceStorageConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String associationId;
        private String resourceType;
        private InstanceStorageConfig storageConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInstanceStorageConfigRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.associationId(model.associationId);
            this.resourceType(model.resourceType);
            this.storageConfig(model.storageConfig);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(InstanceStorageResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final InstanceStorageConfig.Builder getStorageConfig() {
            return this.storageConfig != null ? this.storageConfig.toBuilder() : null;
        }

        public final void setStorageConfig(InstanceStorageConfig.BuilderImpl storageConfig) {
            this.storageConfig = storageConfig != null ? storageConfig.build() : null;
        }

        @Override
        public final Builder storageConfig(InstanceStorageConfig storageConfig) {
            this.storageConfig = storageConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInstanceStorageConfigRequest build() {
            return new UpdateInstanceStorageConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateInstanceStorageConfigRequest> {
        public Builder instanceId(String var1);

        public Builder associationId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(InstanceStorageResourceType var1);

        public Builder storageConfig(InstanceStorageConfig var1);

        default public Builder storageConfig(Consumer<InstanceStorageConfig.Builder> storageConfig) {
            return this.storageConfig((InstanceStorageConfig)((InstanceStorageConfig.Builder)InstanceStorageConfig.builder().applyMutation(storageConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

