/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ChatEvent;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.NewSessionDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendChatIntegrationEventRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, SendChatIntegrationEventRequest> {
    private static final SdkField<String> SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceId").getter(SendChatIntegrationEventRequest.getter(SendChatIntegrationEventRequest::sourceId)).setter(SendChatIntegrationEventRequest.setter(Builder::sourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceId").build()}).build();
    private static final SdkField<String> DESTINATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationId").getter(SendChatIntegrationEventRequest.getter(SendChatIntegrationEventRequest::destinationId)).setter(SendChatIntegrationEventRequest.setter(Builder::destinationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationId").build()}).build();
    private static final SdkField<String> SUBTYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subtype").getter(SendChatIntegrationEventRequest.getter(SendChatIntegrationEventRequest::subtype)).setter(SendChatIntegrationEventRequest.setter(Builder::subtype)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subtype").build()}).build();
    private static final SdkField<ChatEvent> EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Event").getter(SendChatIntegrationEventRequest.getter(SendChatIntegrationEventRequest::event)).setter(SendChatIntegrationEventRequest.setter(Builder::event)).constructor(ChatEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Event").build()}).build();
    private static final SdkField<NewSessionDetails> NEW_SESSION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NewSessionDetails").getter(SendChatIntegrationEventRequest.getter(SendChatIntegrationEventRequest::newSessionDetails)).setter(SendChatIntegrationEventRequest.setter(Builder::newSessionDetails)).constructor(NewSessionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewSessionDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ID_FIELD, DESTINATION_ID_FIELD, SUBTYPE_FIELD, EVENT_FIELD, NEW_SESSION_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SourceId", SOURCE_ID_FIELD);
            this.put("DestinationId", DESTINATION_ID_FIELD);
            this.put("Subtype", SUBTYPE_FIELD);
            this.put("Event", EVENT_FIELD);
            this.put("NewSessionDetails", NEW_SESSION_DETAILS_FIELD);
        }
    });
    private final String sourceId;
    private final String destinationId;
    private final String subtype;
    private final ChatEvent event;
    private final NewSessionDetails newSessionDetails;

    private SendChatIntegrationEventRequest(BuilderImpl builder) {
        super(builder);
        this.sourceId = builder.sourceId;
        this.destinationId = builder.destinationId;
        this.subtype = builder.subtype;
        this.event = builder.event;
        this.newSessionDetails = builder.newSessionDetails;
    }

    public final String sourceId() {
        return this.sourceId;
    }

    public final String destinationId() {
        return this.destinationId;
    }

    public final String subtype() {
        return this.subtype;
    }

    public final ChatEvent event() {
        return this.event;
    }

    public final NewSessionDetails newSessionDetails() {
        return this.newSessionDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subtype());
        hashCode = 31 * hashCode + Objects.hashCode(this.event());
        hashCode = 31 * hashCode + Objects.hashCode(this.newSessionDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendChatIntegrationEventRequest)) {
            return false;
        }
        SendChatIntegrationEventRequest other = (SendChatIntegrationEventRequest)((Object)obj);
        return Objects.equals(this.sourceId(), other.sourceId()) && Objects.equals(this.destinationId(), other.destinationId()) && Objects.equals(this.subtype(), other.subtype()) && Objects.equals(this.event(), other.event()) && Objects.equals(this.newSessionDetails(), other.newSessionDetails());
    }

    public final String toString() {
        return ToString.builder((String)"SendChatIntegrationEventRequest").add("SourceId", (Object)this.sourceId()).add("DestinationId", (Object)this.destinationId()).add("Subtype", (Object)this.subtype()).add("Event", (Object)this.event()).add("NewSessionDetails", (Object)this.newSessionDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceId": {
                return Optional.ofNullable(clazz.cast(this.sourceId()));
            }
            case "DestinationId": {
                return Optional.ofNullable(clazz.cast(this.destinationId()));
            }
            case "Subtype": {
                return Optional.ofNullable(clazz.cast(this.subtype()));
            }
            case "Event": {
                return Optional.ofNullable(clazz.cast(this.event()));
            }
            case "NewSessionDetails": {
                return Optional.ofNullable(clazz.cast(this.newSessionDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SendChatIntegrationEventRequest, T> g) {
        return obj -> g.apply((SendChatIntegrationEventRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String sourceId;
        private String destinationId;
        private String subtype;
        private ChatEvent event;
        private NewSessionDetails newSessionDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(SendChatIntegrationEventRequest model) {
            super(model);
            this.sourceId(model.sourceId);
            this.destinationId(model.destinationId);
            this.subtype(model.subtype);
            this.event(model.event);
            this.newSessionDetails(model.newSessionDetails);
        }

        public final String getSourceId() {
            return this.sourceId;
        }

        public final void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        @Override
        public final Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public final String getDestinationId() {
            return this.destinationId;
        }

        public final void setDestinationId(String destinationId) {
            this.destinationId = destinationId;
        }

        @Override
        public final Builder destinationId(String destinationId) {
            this.destinationId = destinationId;
            return this;
        }

        public final String getSubtype() {
            return this.subtype;
        }

        public final void setSubtype(String subtype) {
            this.subtype = subtype;
        }

        @Override
        public final Builder subtype(String subtype) {
            this.subtype = subtype;
            return this;
        }

        public final ChatEvent.Builder getEvent() {
            return this.event != null ? this.event.toBuilder() : null;
        }

        public final void setEvent(ChatEvent.BuilderImpl event) {
            this.event = event != null ? event.build() : null;
        }

        @Override
        public final Builder event(ChatEvent event) {
            this.event = event;
            return this;
        }

        public final NewSessionDetails.Builder getNewSessionDetails() {
            return this.newSessionDetails != null ? this.newSessionDetails.toBuilder() : null;
        }

        public final void setNewSessionDetails(NewSessionDetails.BuilderImpl newSessionDetails) {
            this.newSessionDetails = newSessionDetails != null ? newSessionDetails.build() : null;
        }

        @Override
        public final Builder newSessionDetails(NewSessionDetails newSessionDetails) {
            this.newSessionDetails = newSessionDetails;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendChatIntegrationEventRequest build() {
            return new SendChatIntegrationEventRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendChatIntegrationEventRequest> {
        public Builder sourceId(String var1);

        public Builder destinationId(String var1);

        public Builder subtype(String var1);

        public Builder event(ChatEvent var1);

        default public Builder event(Consumer<ChatEvent.Builder> event) {
            return this.event((ChatEvent)((ChatEvent.Builder)ChatEvent.builder().applyMutation(event)).build());
        }

        public Builder newSessionDetails(NewSessionDetails var1);

        default public Builder newSessionDetails(Consumer<NewSessionDetails.Builder> newSessionDetails) {
            return this.newSessionDetails((NewSessionDetails)((NewSessionDetails.Builder)NewSessionDetails.builder().applyMutation(newSessionDetails)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

