/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.SecurityProfileSearchSummary;
import software.amazon.awssdk.services.connect.model.SecurityProfilesSearchSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchSecurityProfilesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, SearchSecurityProfilesResponse> {
    private static final SdkField<List<SecurityProfileSearchSummary>> SECURITY_PROFILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityProfiles").getter(SearchSecurityProfilesResponse.getter(SearchSecurityProfilesResponse::securityProfiles)).setter(SearchSecurityProfilesResponse.setter(Builder::securityProfiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityProfiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecurityProfileSearchSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchSecurityProfilesResponse.getter(SearchSecurityProfilesResponse::nextToken)).setter(SearchSecurityProfilesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Long> APPROXIMATE_TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApproximateTotalCount").getter(SearchSecurityProfilesResponse.getter(SearchSecurityProfilesResponse::approximateTotalCount)).setter(SearchSecurityProfilesResponse.setter(Builder::approximateTotalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateTotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_PROFILES_FIELD, NEXT_TOKEN_FIELD, APPROXIMATE_TOTAL_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SecurityProfiles", SECURITY_PROFILES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("ApproximateTotalCount", APPROXIMATE_TOTAL_COUNT_FIELD);
        }
    });
    private final List<SecurityProfileSearchSummary> securityProfiles;
    private final String nextToken;
    private final Long approximateTotalCount;

    private SearchSecurityProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.securityProfiles = builder.securityProfiles;
        this.nextToken = builder.nextToken;
        this.approximateTotalCount = builder.approximateTotalCount;
    }

    public final boolean hasSecurityProfiles() {
        return this.securityProfiles != null && !(this.securityProfiles instanceof SdkAutoConstructList);
    }

    public final List<SecurityProfileSearchSummary> securityProfiles() {
        return this.securityProfiles;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Long approximateTotalCount() {
        return this.approximateTotalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityProfiles() ? this.securityProfiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateTotalCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchSecurityProfilesResponse)) {
            return false;
        }
        SearchSecurityProfilesResponse other = (SearchSecurityProfilesResponse)((Object)obj);
        return this.hasSecurityProfiles() == other.hasSecurityProfiles() && Objects.equals(this.securityProfiles(), other.securityProfiles()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.approximateTotalCount(), other.approximateTotalCount());
    }

    public final String toString() {
        return ToString.builder((String)"SearchSecurityProfilesResponse").add("SecurityProfiles", this.hasSecurityProfiles() ? this.securityProfiles() : null).add("NextToken", (Object)this.nextToken()).add("ApproximateTotalCount", (Object)this.approximateTotalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityProfiles": {
                return Optional.ofNullable(clazz.cast(this.securityProfiles()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ApproximateTotalCount": {
                return Optional.ofNullable(clazz.cast(this.approximateTotalCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchSecurityProfilesResponse, T> g) {
        return obj -> g.apply((SearchSecurityProfilesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<SecurityProfileSearchSummary> securityProfiles = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Long approximateTotalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchSecurityProfilesResponse model) {
            super(model);
            this.securityProfiles(model.securityProfiles);
            this.nextToken(model.nextToken);
            this.approximateTotalCount(model.approximateTotalCount);
        }

        public final List<SecurityProfileSearchSummary.Builder> getSecurityProfiles() {
            List<SecurityProfileSearchSummary.Builder> result = SecurityProfilesSearchSummaryListCopier.copyToBuilder(this.securityProfiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityProfiles(Collection<SecurityProfileSearchSummary.BuilderImpl> securityProfiles) {
            this.securityProfiles = SecurityProfilesSearchSummaryListCopier.copyFromBuilder(securityProfiles);
        }

        @Override
        public final Builder securityProfiles(Collection<SecurityProfileSearchSummary> securityProfiles) {
            this.securityProfiles = SecurityProfilesSearchSummaryListCopier.copy(securityProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfiles(SecurityProfileSearchSummary ... securityProfiles) {
            this.securityProfiles(Arrays.asList(securityProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfiles(Consumer<SecurityProfileSearchSummary.Builder> ... securityProfiles) {
            this.securityProfiles(Stream.of(securityProfiles).map(c -> (SecurityProfileSearchSummary)((SecurityProfileSearchSummary.Builder)SecurityProfileSearchSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Long getApproximateTotalCount() {
            return this.approximateTotalCount;
        }

        public final void setApproximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
        }

        @Override
        public final Builder approximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
            return this;
        }

        @Override
        public SearchSecurityProfilesResponse build() {
            return new SearchSecurityProfilesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchSecurityProfilesResponse> {
        public Builder securityProfiles(Collection<SecurityProfileSearchSummary> var1);

        public Builder securityProfiles(SecurityProfileSearchSummary ... var1);

        public Builder securityProfiles(Consumer<SecurityProfileSearchSummary.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder approximateTotalCount(Long var1);
    }
}

