/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.RoutingProfileSummary;
import software.amazon.awssdk.services.connect.model.RoutingProfileSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRoutingProfilesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListRoutingProfilesResponse> {
    private static final SdkField<List<RoutingProfileSummary>> ROUTING_PROFILE_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RoutingProfileSummaryList").getter(ListRoutingProfilesResponse.getter(ListRoutingProfilesResponse::routingProfileSummaryList)).setter(ListRoutingProfilesResponse.setter(Builder::routingProfileSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfileSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RoutingProfileSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRoutingProfilesResponse.getter(ListRoutingProfilesResponse::nextToken)).setter(ListRoutingProfilesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTING_PROFILE_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RoutingProfileSummaryList", ROUTING_PROFILE_SUMMARY_LIST_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<RoutingProfileSummary> routingProfileSummaryList;
    private final String nextToken;

    private ListRoutingProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.routingProfileSummaryList = builder.routingProfileSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRoutingProfileSummaryList() {
        return this.routingProfileSummaryList != null && !(this.routingProfileSummaryList instanceof SdkAutoConstructList);
    }

    public final List<RoutingProfileSummary> routingProfileSummaryList() {
        return this.routingProfileSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutingProfileSummaryList() ? this.routingProfileSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRoutingProfilesResponse)) {
            return false;
        }
        ListRoutingProfilesResponse other = (ListRoutingProfilesResponse)((Object)obj);
        return this.hasRoutingProfileSummaryList() == other.hasRoutingProfileSummaryList() && Objects.equals(this.routingProfileSummaryList(), other.routingProfileSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRoutingProfilesResponse").add("RoutingProfileSummaryList", this.hasRoutingProfileSummaryList() ? this.routingProfileSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoutingProfileSummaryList": {
                return Optional.ofNullable(clazz.cast(this.routingProfileSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListRoutingProfilesResponse, T> g) {
        return obj -> g.apply((ListRoutingProfilesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<RoutingProfileSummary> routingProfileSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRoutingProfilesResponse model) {
            super(model);
            this.routingProfileSummaryList(model.routingProfileSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<RoutingProfileSummary.Builder> getRoutingProfileSummaryList() {
            List<RoutingProfileSummary.Builder> result = RoutingProfileSummaryListCopier.copyToBuilder(this.routingProfileSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutingProfileSummaryList(Collection<RoutingProfileSummary.BuilderImpl> routingProfileSummaryList) {
            this.routingProfileSummaryList = RoutingProfileSummaryListCopier.copyFromBuilder(routingProfileSummaryList);
        }

        @Override
        public final Builder routingProfileSummaryList(Collection<RoutingProfileSummary> routingProfileSummaryList) {
            this.routingProfileSummaryList = RoutingProfileSummaryListCopier.copy(routingProfileSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingProfileSummaryList(RoutingProfileSummary ... routingProfileSummaryList) {
            this.routingProfileSummaryList(Arrays.asList(routingProfileSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingProfileSummaryList(Consumer<RoutingProfileSummary.Builder> ... routingProfileSummaryList) {
            this.routingProfileSummaryList(Stream.of(routingProfileSummaryList).map(c -> (RoutingProfileSummary)((RoutingProfileSummary.Builder)RoutingProfileSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRoutingProfilesResponse build() {
            return new ListRoutingProfilesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRoutingProfilesResponse> {
        public Builder routingProfileSummaryList(Collection<RoutingProfileSummary> var1);

        public Builder routingProfileSummaryList(RoutingProfileSummary ... var1);

        public Builder routingProfileSummaryList(Consumer<RoutingProfileSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

