/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.RoutingProfileQueueConfigSummary;
import software.amazon.awssdk.services.connect.model.RoutingProfileQueueConfigSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRoutingProfileQueuesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListRoutingProfileQueuesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRoutingProfileQueuesResponse.getter(ListRoutingProfileQueuesResponse::nextToken)).setter(ListRoutingProfileQueuesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<RoutingProfileQueueConfigSummary>> ROUTING_PROFILE_QUEUE_CONFIG_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RoutingProfileQueueConfigSummaryList").getter(ListRoutingProfileQueuesResponse.getter(ListRoutingProfileQueuesResponse::routingProfileQueueConfigSummaryList)).setter(ListRoutingProfileQueuesResponse.setter(Builder::routingProfileQueueConfigSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfileQueueConfigSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RoutingProfileQueueConfigSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(ListRoutingProfileQueuesResponse.getter(ListRoutingProfileQueuesResponse::lastModifiedTime)).setter(ListRoutingProfileQueuesResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedRegion").getter(ListRoutingProfileQueuesResponse.getter(ListRoutingProfileQueuesResponse::lastModifiedRegion)).setter(ListRoutingProfileQueuesResponse.setter(Builder::lastModifiedRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ROUTING_PROFILE_QUEUE_CONFIG_SUMMARY_LIST_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("RoutingProfileQueueConfigSummaryList", ROUTING_PROFILE_QUEUE_CONFIG_SUMMARY_LIST_FIELD);
            this.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
            this.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        }
    });
    private final String nextToken;
    private final List<RoutingProfileQueueConfigSummary> routingProfileQueueConfigSummaryList;
    private final Instant lastModifiedTime;
    private final String lastModifiedRegion;

    private ListRoutingProfileQueuesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.routingProfileQueueConfigSummaryList = builder.routingProfileQueueConfigSummaryList;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRoutingProfileQueueConfigSummaryList() {
        return this.routingProfileQueueConfigSummaryList != null && !(this.routingProfileQueueConfigSummaryList instanceof SdkAutoConstructList);
    }

    public final List<RoutingProfileQueueConfigSummary> routingProfileQueueConfigSummaryList() {
        return this.routingProfileQueueConfigSummaryList;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String lastModifiedRegion() {
        return this.lastModifiedRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutingProfileQueueConfigSummaryList() ? this.routingProfileQueueConfigSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRoutingProfileQueuesResponse)) {
            return false;
        }
        ListRoutingProfileQueuesResponse other = (ListRoutingProfileQueuesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRoutingProfileQueueConfigSummaryList() == other.hasRoutingProfileQueueConfigSummaryList() && Objects.equals(this.routingProfileQueueConfigSummaryList(), other.routingProfileQueueConfigSummaryList()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedRegion(), other.lastModifiedRegion());
    }

    public final String toString() {
        return ToString.builder((String)"ListRoutingProfileQueuesResponse").add("NextToken", (Object)this.nextToken()).add("RoutingProfileQueueConfigSummaryList", this.hasRoutingProfileQueueConfigSummaryList() ? this.routingProfileQueueConfigSummaryList() : null).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedRegion", (Object)this.lastModifiedRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RoutingProfileQueueConfigSummaryList": {
                return Optional.ofNullable(clazz.cast(this.routingProfileQueueConfigSummaryList()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedRegion": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListRoutingProfileQueuesResponse, T> g) {
        return obj -> g.apply((ListRoutingProfileQueuesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<RoutingProfileQueueConfigSummary> routingProfileQueueConfigSummaryList = DefaultSdkAutoConstructList.getInstance();
        private Instant lastModifiedTime;
        private String lastModifiedRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRoutingProfileQueuesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.routingProfileQueueConfigSummaryList(model.routingProfileQueueConfigSummaryList);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedRegion(model.lastModifiedRegion);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RoutingProfileQueueConfigSummary.Builder> getRoutingProfileQueueConfigSummaryList() {
            List<RoutingProfileQueueConfigSummary.Builder> result = RoutingProfileQueueConfigSummaryListCopier.copyToBuilder(this.routingProfileQueueConfigSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutingProfileQueueConfigSummaryList(Collection<RoutingProfileQueueConfigSummary.BuilderImpl> routingProfileQueueConfigSummaryList) {
            this.routingProfileQueueConfigSummaryList = RoutingProfileQueueConfigSummaryListCopier.copyFromBuilder(routingProfileQueueConfigSummaryList);
        }

        @Override
        public final Builder routingProfileQueueConfigSummaryList(Collection<RoutingProfileQueueConfigSummary> routingProfileQueueConfigSummaryList) {
            this.routingProfileQueueConfigSummaryList = RoutingProfileQueueConfigSummaryListCopier.copy(routingProfileQueueConfigSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingProfileQueueConfigSummaryList(RoutingProfileQueueConfigSummary ... routingProfileQueueConfigSummaryList) {
            this.routingProfileQueueConfigSummaryList(Arrays.asList(routingProfileQueueConfigSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingProfileQueueConfigSummaryList(Consumer<RoutingProfileQueueConfigSummary.Builder> ... routingProfileQueueConfigSummaryList) {
            this.routingProfileQueueConfigSummaryList(Stream.of(routingProfileQueueConfigSummaryList).map(c -> (RoutingProfileQueueConfigSummary)((RoutingProfileQueueConfigSummary.Builder)RoutingProfileQueueConfigSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return this.lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        @Override
        public ListRoutingProfileQueuesResponse build() {
            return new ListRoutingProfileQueuesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRoutingProfileQueuesResponse> {
        public Builder nextToken(String var1);

        public Builder routingProfileQueueConfigSummaryList(Collection<RoutingProfileQueueConfigSummary> var1);

        public Builder routingProfileQueueConfigSummaryList(RoutingProfileQueueConfigSummary ... var1);

        public Builder routingProfileQueueConfigSummaryList(Consumer<RoutingProfileQueueConfigSummary.Builder> ... var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedRegion(String var1);
    }
}

