/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.LexBot;
import software.amazon.awssdk.services.connect.model.LexV2Bot;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LexBotConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LexBotConfig> {
    private static final SdkField<LexBot> LEX_BOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LexBot").getter(LexBotConfig.getter(LexBotConfig::lexBot)).setter(LexBotConfig.setter(Builder::lexBot)).constructor(LexBot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LexBot").build()}).build();
    private static final SdkField<LexV2Bot> LEX_V2_BOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LexV2Bot").getter(LexBotConfig.getter(LexBotConfig::lexV2Bot)).setter(LexBotConfig.setter(Builder::lexV2Bot)).constructor(LexV2Bot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LexV2Bot").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEX_BOT_FIELD, LEX_V2_BOT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LexBot", LEX_BOT_FIELD);
            this.put("LexV2Bot", LEX_V2_BOT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final LexBot lexBot;
    private final LexV2Bot lexV2Bot;

    private LexBotConfig(BuilderImpl builder) {
        this.lexBot = builder.lexBot;
        this.lexV2Bot = builder.lexV2Bot;
    }

    public final LexBot lexBot() {
        return this.lexBot;
    }

    public final LexV2Bot lexV2Bot() {
        return this.lexV2Bot;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lexBot());
        hashCode = 31 * hashCode + Objects.hashCode(this.lexV2Bot());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LexBotConfig)) {
            return false;
        }
        LexBotConfig other = (LexBotConfig)obj;
        return Objects.equals(this.lexBot(), other.lexBot()) && Objects.equals(this.lexV2Bot(), other.lexV2Bot());
    }

    public final String toString() {
        return ToString.builder((String)"LexBotConfig").add("LexBot", (Object)this.lexBot()).add("LexV2Bot", (Object)this.lexV2Bot()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LexBot": {
                return Optional.ofNullable(clazz.cast(this.lexBot()));
            }
            case "LexV2Bot": {
                return Optional.ofNullable(clazz.cast(this.lexV2Bot()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LexBotConfig, T> g) {
        return obj -> g.apply((LexBotConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LexBot lexBot;
        private LexV2Bot lexV2Bot;

        private BuilderImpl() {
        }

        private BuilderImpl(LexBotConfig model) {
            this.lexBot(model.lexBot);
            this.lexV2Bot(model.lexV2Bot);
        }

        public final LexBot.Builder getLexBot() {
            return this.lexBot != null ? this.lexBot.toBuilder() : null;
        }

        public final void setLexBot(LexBot.BuilderImpl lexBot) {
            this.lexBot = lexBot != null ? lexBot.build() : null;
        }

        @Override
        public final Builder lexBot(LexBot lexBot) {
            this.lexBot = lexBot;
            return this;
        }

        public final LexV2Bot.Builder getLexV2Bot() {
            return this.lexV2Bot != null ? this.lexV2Bot.toBuilder() : null;
        }

        public final void setLexV2Bot(LexV2Bot.BuilderImpl lexV2Bot) {
            this.lexV2Bot = lexV2Bot != null ? lexV2Bot.build() : null;
        }

        @Override
        public final Builder lexV2Bot(LexV2Bot lexV2Bot) {
            this.lexV2Bot = lexV2Bot;
            return this;
        }

        public LexBotConfig build() {
            return new LexBotConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LexBotConfig> {
        public Builder lexBot(LexBot var1);

        default public Builder lexBot(Consumer<LexBot.Builder> lexBot) {
            return this.lexBot((LexBot)((LexBot.Builder)LexBot.builder().applyMutation(lexBot)).build());
        }

        public Builder lexV2Bot(LexV2Bot var1);

        default public Builder lexV2Bot(Consumer<LexV2Bot.Builder> lexV2Bot) {
            return this.lexV2Bot((LexV2Bot)((LexV2Bot.Builder)LexV2Bot.builder().applyMutation(lexV2Bot)).build());
        }
    }
}

