/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.CommonAttributeAndCondition;
import software.amazon.awssdk.services.connect.model.CommonAttributeOrConditionListCopier;
import software.amazon.awssdk.services.connect.model.TagCondition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ControlPlaneAttributeFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ControlPlaneAttributeFilter> {
    private static final SdkField<List<CommonAttributeAndCondition>> OR_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrConditions").getter(ControlPlaneAttributeFilter.getter(ControlPlaneAttributeFilter::orConditions)).setter(ControlPlaneAttributeFilter.setter(Builder::orConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CommonAttributeAndCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CommonAttributeAndCondition> AND_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AndCondition").getter(ControlPlaneAttributeFilter.getter(ControlPlaneAttributeFilter::andCondition)).setter(ControlPlaneAttributeFilter.setter(Builder::andCondition)).constructor(CommonAttributeAndCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AndCondition").build()}).build();
    private static final SdkField<TagCondition> TAG_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TagCondition").getter(ControlPlaneAttributeFilter.getter(ControlPlaneAttributeFilter::tagCondition)).setter(ControlPlaneAttributeFilter.setter(Builder::tagCondition)).constructor(TagCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagCondition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OR_CONDITIONS_FIELD, AND_CONDITION_FIELD, TAG_CONDITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OrConditions", OR_CONDITIONS_FIELD);
            this.put("AndCondition", AND_CONDITION_FIELD);
            this.put("TagCondition", TAG_CONDITION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<CommonAttributeAndCondition> orConditions;
    private final CommonAttributeAndCondition andCondition;
    private final TagCondition tagCondition;

    private ControlPlaneAttributeFilter(BuilderImpl builder) {
        this.orConditions = builder.orConditions;
        this.andCondition = builder.andCondition;
        this.tagCondition = builder.tagCondition;
    }

    public final boolean hasOrConditions() {
        return this.orConditions != null && !(this.orConditions instanceof SdkAutoConstructList);
    }

    public final List<CommonAttributeAndCondition> orConditions() {
        return this.orConditions;
    }

    public final CommonAttributeAndCondition andCondition() {
        return this.andCondition;
    }

    public final TagCondition tagCondition() {
        return this.tagCondition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrConditions() ? this.orConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.andCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagCondition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlPlaneAttributeFilter)) {
            return false;
        }
        ControlPlaneAttributeFilter other = (ControlPlaneAttributeFilter)obj;
        return this.hasOrConditions() == other.hasOrConditions() && Objects.equals(this.orConditions(), other.orConditions()) && Objects.equals(this.andCondition(), other.andCondition()) && Objects.equals(this.tagCondition(), other.tagCondition());
    }

    public final String toString() {
        return ToString.builder((String)"ControlPlaneAttributeFilter").add("OrConditions", this.hasOrConditions() ? this.orConditions() : null).add("AndCondition", (Object)this.andCondition()).add("TagCondition", (Object)this.tagCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrConditions": {
                return Optional.ofNullable(clazz.cast(this.orConditions()));
            }
            case "AndCondition": {
                return Optional.ofNullable(clazz.cast(this.andCondition()));
            }
            case "TagCondition": {
                return Optional.ofNullable(clazz.cast(this.tagCondition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ControlPlaneAttributeFilter, T> g) {
        return obj -> g.apply((ControlPlaneAttributeFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CommonAttributeAndCondition> orConditions = DefaultSdkAutoConstructList.getInstance();
        private CommonAttributeAndCondition andCondition;
        private TagCondition tagCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(ControlPlaneAttributeFilter model) {
            this.orConditions(model.orConditions);
            this.andCondition(model.andCondition);
            this.tagCondition(model.tagCondition);
        }

        public final List<CommonAttributeAndCondition.Builder> getOrConditions() {
            List<CommonAttributeAndCondition.Builder> result = CommonAttributeOrConditionListCopier.copyToBuilder(this.orConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrConditions(Collection<CommonAttributeAndCondition.BuilderImpl> orConditions) {
            this.orConditions = CommonAttributeOrConditionListCopier.copyFromBuilder(orConditions);
        }

        @Override
        public final Builder orConditions(Collection<CommonAttributeAndCondition> orConditions) {
            this.orConditions = CommonAttributeOrConditionListCopier.copy(orConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(CommonAttributeAndCondition ... orConditions) {
            this.orConditions(Arrays.asList(orConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(Consumer<CommonAttributeAndCondition.Builder> ... orConditions) {
            this.orConditions(Stream.of(orConditions).map(c -> (CommonAttributeAndCondition)((CommonAttributeAndCondition.Builder)CommonAttributeAndCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CommonAttributeAndCondition.Builder getAndCondition() {
            return this.andCondition != null ? this.andCondition.toBuilder() : null;
        }

        public final void setAndCondition(CommonAttributeAndCondition.BuilderImpl andCondition) {
            this.andCondition = andCondition != null ? andCondition.build() : null;
        }

        @Override
        public final Builder andCondition(CommonAttributeAndCondition andCondition) {
            this.andCondition = andCondition;
            return this;
        }

        public final TagCondition.Builder getTagCondition() {
            return this.tagCondition != null ? this.tagCondition.toBuilder() : null;
        }

        public final void setTagCondition(TagCondition.BuilderImpl tagCondition) {
            this.tagCondition = tagCondition != null ? tagCondition.build() : null;
        }

        @Override
        public final Builder tagCondition(TagCondition tagCondition) {
            this.tagCondition = tagCondition;
            return this;
        }

        public ControlPlaneAttributeFilter build() {
            return new ControlPlaneAttributeFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ControlPlaneAttributeFilter> {
        public Builder orConditions(Collection<CommonAttributeAndCondition> var1);

        public Builder orConditions(CommonAttributeAndCondition ... var1);

        public Builder orConditions(Consumer<CommonAttributeAndCondition.Builder> ... var1);

        public Builder andCondition(CommonAttributeAndCondition var1);

        default public Builder andCondition(Consumer<CommonAttributeAndCondition.Builder> andCondition) {
            return this.andCondition((CommonAttributeAndCondition)((CommonAttributeAndCondition.Builder)CommonAttributeAndCondition.builder().applyMutation(andCondition)).build());
        }

        public Builder tagCondition(TagCondition var1);

        default public Builder tagCondition(Consumer<TagCondition.Builder> tagCondition) {
            return this.tagCondition((TagCondition)((TagCondition.Builder)TagCondition.builder().applyMutation(tagCondition)).build());
        }
    }
}

