/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ContactFlowSearchConditionListCopier;
import software.amazon.awssdk.services.connect.model.ContactFlowState;
import software.amazon.awssdk.services.connect.model.ContactFlowStatus;
import software.amazon.awssdk.services.connect.model.ContactFlowType;
import software.amazon.awssdk.services.connect.model.StringCondition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContactFlowSearchCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContactFlowSearchCriteria> {
    private static final SdkField<List<ContactFlowSearchCriteria>> OR_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrConditions").getter(ContactFlowSearchCriteria.getter(ContactFlowSearchCriteria::orConditions)).setter(ContactFlowSearchCriteria.setter(Builder::orConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContactFlowSearchCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ContactFlowSearchCriteria>> AND_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AndConditions").getter(ContactFlowSearchCriteria.getter(ContactFlowSearchCriteria::andConditions)).setter(ContactFlowSearchCriteria.setter(Builder::andConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AndConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContactFlowSearchCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<StringCondition> STRING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StringCondition").getter(ContactFlowSearchCriteria.getter(ContactFlowSearchCriteria::stringCondition)).setter(ContactFlowSearchCriteria.setter(Builder::stringCondition)).constructor(StringCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringCondition").build()}).build();
    private static final SdkField<String> TYPE_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeCondition").getter(ContactFlowSearchCriteria.getter(ContactFlowSearchCriteria::typeConditionAsString)).setter(ContactFlowSearchCriteria.setter(Builder::typeCondition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeCondition").build()}).build();
    private static final SdkField<String> STATE_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateCondition").getter(ContactFlowSearchCriteria.getter(ContactFlowSearchCriteria::stateConditionAsString)).setter(ContactFlowSearchCriteria.setter(Builder::stateCondition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateCondition").build()}).build();
    private static final SdkField<String> STATUS_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusCondition").getter(ContactFlowSearchCriteria.getter(ContactFlowSearchCriteria::statusConditionAsString)).setter(ContactFlowSearchCriteria.setter(Builder::statusCondition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCondition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OR_CONDITIONS_FIELD, AND_CONDITIONS_FIELD, STRING_CONDITION_FIELD, TYPE_CONDITION_FIELD, STATE_CONDITION_FIELD, STATUS_CONDITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OrConditions", OR_CONDITIONS_FIELD);
            this.put("AndConditions", AND_CONDITIONS_FIELD);
            this.put("StringCondition", STRING_CONDITION_FIELD);
            this.put("TypeCondition", TYPE_CONDITION_FIELD);
            this.put("StateCondition", STATE_CONDITION_FIELD);
            this.put("StatusCondition", STATUS_CONDITION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<ContactFlowSearchCriteria> orConditions;
    private final List<ContactFlowSearchCriteria> andConditions;
    private final StringCondition stringCondition;
    private final String typeCondition;
    private final String stateCondition;
    private final String statusCondition;

    private ContactFlowSearchCriteria(BuilderImpl builder) {
        this.orConditions = builder.orConditions;
        this.andConditions = builder.andConditions;
        this.stringCondition = builder.stringCondition;
        this.typeCondition = builder.typeCondition;
        this.stateCondition = builder.stateCondition;
        this.statusCondition = builder.statusCondition;
    }

    public final boolean hasOrConditions() {
        return this.orConditions != null && !(this.orConditions instanceof SdkAutoConstructList);
    }

    public final List<ContactFlowSearchCriteria> orConditions() {
        return this.orConditions;
    }

    public final boolean hasAndConditions() {
        return this.andConditions != null && !(this.andConditions instanceof SdkAutoConstructList);
    }

    public final List<ContactFlowSearchCriteria> andConditions() {
        return this.andConditions;
    }

    public final StringCondition stringCondition() {
        return this.stringCondition;
    }

    public final ContactFlowType typeCondition() {
        return ContactFlowType.fromValue(this.typeCondition);
    }

    public final String typeConditionAsString() {
        return this.typeCondition;
    }

    public final ContactFlowState stateCondition() {
        return ContactFlowState.fromValue(this.stateCondition);
    }

    public final String stateConditionAsString() {
        return this.stateCondition;
    }

    public final ContactFlowStatus statusCondition() {
        return ContactFlowStatus.fromValue(this.statusCondition);
    }

    public final String statusConditionAsString() {
        return this.statusCondition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrConditions() ? this.orConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAndConditions() ? this.andConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stringCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeConditionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateConditionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusConditionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactFlowSearchCriteria)) {
            return false;
        }
        ContactFlowSearchCriteria other = (ContactFlowSearchCriteria)obj;
        return this.hasOrConditions() == other.hasOrConditions() && Objects.equals(this.orConditions(), other.orConditions()) && this.hasAndConditions() == other.hasAndConditions() && Objects.equals(this.andConditions(), other.andConditions()) && Objects.equals(this.stringCondition(), other.stringCondition()) && Objects.equals(this.typeConditionAsString(), other.typeConditionAsString()) && Objects.equals(this.stateConditionAsString(), other.stateConditionAsString()) && Objects.equals(this.statusConditionAsString(), other.statusConditionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ContactFlowSearchCriteria").add("OrConditions", this.hasOrConditions() ? this.orConditions() : null).add("AndConditions", this.hasAndConditions() ? this.andConditions() : null).add("StringCondition", (Object)this.stringCondition()).add("TypeCondition", (Object)this.typeConditionAsString()).add("StateCondition", (Object)this.stateConditionAsString()).add("StatusCondition", (Object)this.statusConditionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrConditions": {
                return Optional.ofNullable(clazz.cast(this.orConditions()));
            }
            case "AndConditions": {
                return Optional.ofNullable(clazz.cast(this.andConditions()));
            }
            case "StringCondition": {
                return Optional.ofNullable(clazz.cast(this.stringCondition()));
            }
            case "TypeCondition": {
                return Optional.ofNullable(clazz.cast(this.typeConditionAsString()));
            }
            case "StateCondition": {
                return Optional.ofNullable(clazz.cast(this.stateConditionAsString()));
            }
            case "StatusCondition": {
                return Optional.ofNullable(clazz.cast(this.statusConditionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ContactFlowSearchCriteria, T> g) {
        return obj -> g.apply((ContactFlowSearchCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ContactFlowSearchCriteria> orConditions = DefaultSdkAutoConstructList.getInstance();
        private List<ContactFlowSearchCriteria> andConditions = DefaultSdkAutoConstructList.getInstance();
        private StringCondition stringCondition;
        private String typeCondition;
        private String stateCondition;
        private String statusCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactFlowSearchCriteria model) {
            this.orConditions(model.orConditions);
            this.andConditions(model.andConditions);
            this.stringCondition(model.stringCondition);
            this.typeCondition(model.typeCondition);
            this.stateCondition(model.stateCondition);
            this.statusCondition(model.statusCondition);
        }

        public final List<Builder> getOrConditions() {
            List<Builder> result = ContactFlowSearchConditionListCopier.copyToBuilder(this.orConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrConditions(Collection<BuilderImpl> orConditions) {
            this.orConditions = ContactFlowSearchConditionListCopier.copyFromBuilder(orConditions);
        }

        @Override
        public final Builder orConditions(Collection<ContactFlowSearchCriteria> orConditions) {
            this.orConditions = ContactFlowSearchConditionListCopier.copy(orConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(ContactFlowSearchCriteria ... orConditions) {
            this.orConditions(Arrays.asList(orConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(Consumer<Builder> ... orConditions) {
            this.orConditions(Stream.of(orConditions).map(c -> (ContactFlowSearchCriteria)((Builder)ContactFlowSearchCriteria.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getAndConditions() {
            List<Builder> result = ContactFlowSearchConditionListCopier.copyToBuilder(this.andConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAndConditions(Collection<BuilderImpl> andConditions) {
            this.andConditions = ContactFlowSearchConditionListCopier.copyFromBuilder(andConditions);
        }

        @Override
        public final Builder andConditions(Collection<ContactFlowSearchCriteria> andConditions) {
            this.andConditions = ContactFlowSearchConditionListCopier.copy(andConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(ContactFlowSearchCriteria ... andConditions) {
            this.andConditions(Arrays.asList(andConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(Consumer<Builder> ... andConditions) {
            this.andConditions(Stream.of(andConditions).map(c -> (ContactFlowSearchCriteria)((Builder)ContactFlowSearchCriteria.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final StringCondition.Builder getStringCondition() {
            return this.stringCondition != null ? this.stringCondition.toBuilder() : null;
        }

        public final void setStringCondition(StringCondition.BuilderImpl stringCondition) {
            this.stringCondition = stringCondition != null ? stringCondition.build() : null;
        }

        @Override
        public final Builder stringCondition(StringCondition stringCondition) {
            this.stringCondition = stringCondition;
            return this;
        }

        public final String getTypeCondition() {
            return this.typeCondition;
        }

        public final void setTypeCondition(String typeCondition) {
            this.typeCondition = typeCondition;
        }

        @Override
        public final Builder typeCondition(String typeCondition) {
            this.typeCondition = typeCondition;
            return this;
        }

        @Override
        public final Builder typeCondition(ContactFlowType typeCondition) {
            this.typeCondition(typeCondition == null ? null : typeCondition.toString());
            return this;
        }

        public final String getStateCondition() {
            return this.stateCondition;
        }

        public final void setStateCondition(String stateCondition) {
            this.stateCondition = stateCondition;
        }

        @Override
        public final Builder stateCondition(String stateCondition) {
            this.stateCondition = stateCondition;
            return this;
        }

        @Override
        public final Builder stateCondition(ContactFlowState stateCondition) {
            this.stateCondition(stateCondition == null ? null : stateCondition.toString());
            return this;
        }

        public final String getStatusCondition() {
            return this.statusCondition;
        }

        public final void setStatusCondition(String statusCondition) {
            this.statusCondition = statusCondition;
        }

        @Override
        public final Builder statusCondition(String statusCondition) {
            this.statusCondition = statusCondition;
            return this;
        }

        @Override
        public final Builder statusCondition(ContactFlowStatus statusCondition) {
            this.statusCondition(statusCondition == null ? null : statusCondition.toString());
            return this;
        }

        public ContactFlowSearchCriteria build() {
            return new ContactFlowSearchCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContactFlowSearchCriteria> {
        public Builder orConditions(Collection<ContactFlowSearchCriteria> var1);

        public Builder orConditions(ContactFlowSearchCriteria ... var1);

        public Builder orConditions(Consumer<Builder> ... var1);

        public Builder andConditions(Collection<ContactFlowSearchCriteria> var1);

        public Builder andConditions(ContactFlowSearchCriteria ... var1);

        public Builder andConditions(Consumer<Builder> ... var1);

        public Builder stringCondition(StringCondition var1);

        default public Builder stringCondition(Consumer<StringCondition.Builder> stringCondition) {
            return this.stringCondition((StringCondition)((StringCondition.Builder)StringCondition.builder().applyMutation(stringCondition)).build());
        }

        public Builder typeCondition(String var1);

        public Builder typeCondition(ContactFlowType var1);

        public Builder stateCondition(String var1);

        public Builder stateCondition(ContactFlowState var1);

        public Builder statusCondition(String var1);

        public Builder statusCondition(ContactFlowStatus var1);
    }
}

