/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.PotentialAudioQualityIssuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioQualityMetricsInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioQualityMetricsInfo> {
    private static final SdkField<Float> QUALITY_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("QualityScore").getter(AudioQualityMetricsInfo.getter(AudioQualityMetricsInfo::qualityScore)).setter(AudioQualityMetricsInfo.setter(Builder::qualityScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualityScore").build()}).build();
    private static final SdkField<List<String>> POTENTIAL_QUALITY_ISSUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PotentialQualityIssues").getter(AudioQualityMetricsInfo.getter(AudioQualityMetricsInfo::potentialQualityIssues)).setter(AudioQualityMetricsInfo.setter(Builder::potentialQualityIssues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PotentialQualityIssues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUALITY_SCORE_FIELD, POTENTIAL_QUALITY_ISSUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("QualityScore", QUALITY_SCORE_FIELD);
            this.put("PotentialQualityIssues", POTENTIAL_QUALITY_ISSUES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Float qualityScore;
    private final List<String> potentialQualityIssues;

    private AudioQualityMetricsInfo(BuilderImpl builder) {
        this.qualityScore = builder.qualityScore;
        this.potentialQualityIssues = builder.potentialQualityIssues;
    }

    public final Float qualityScore() {
        return this.qualityScore;
    }

    public final boolean hasPotentialQualityIssues() {
        return this.potentialQualityIssues != null && !(this.potentialQualityIssues instanceof SdkAutoConstructList);
    }

    public final List<String> potentialQualityIssues() {
        return this.potentialQualityIssues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.qualityScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPotentialQualityIssues() ? this.potentialQualityIssues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioQualityMetricsInfo)) {
            return false;
        }
        AudioQualityMetricsInfo other = (AudioQualityMetricsInfo)obj;
        return Objects.equals(this.qualityScore(), other.qualityScore()) && this.hasPotentialQualityIssues() == other.hasPotentialQualityIssues() && Objects.equals(this.potentialQualityIssues(), other.potentialQualityIssues());
    }

    public final String toString() {
        return ToString.builder((String)"AudioQualityMetricsInfo").add("QualityScore", (Object)this.qualityScore()).add("PotentialQualityIssues", this.hasPotentialQualityIssues() ? this.potentialQualityIssues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QualityScore": {
                return Optional.ofNullable(clazz.cast(this.qualityScore()));
            }
            case "PotentialQualityIssues": {
                return Optional.ofNullable(clazz.cast(this.potentialQualityIssues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AudioQualityMetricsInfo, T> g) {
        return obj -> g.apply((AudioQualityMetricsInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Float qualityScore;
        private List<String> potentialQualityIssues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AudioQualityMetricsInfo model) {
            this.qualityScore(model.qualityScore);
            this.potentialQualityIssues(model.potentialQualityIssues);
        }

        public final Float getQualityScore() {
            return this.qualityScore;
        }

        public final void setQualityScore(Float qualityScore) {
            this.qualityScore = qualityScore;
        }

        @Override
        public final Builder qualityScore(Float qualityScore) {
            this.qualityScore = qualityScore;
            return this;
        }

        public final Collection<String> getPotentialQualityIssues() {
            if (this.potentialQualityIssues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.potentialQualityIssues;
        }

        public final void setPotentialQualityIssues(Collection<String> potentialQualityIssues) {
            this.potentialQualityIssues = PotentialAudioQualityIssuesCopier.copy(potentialQualityIssues);
        }

        @Override
        public final Builder potentialQualityIssues(Collection<String> potentialQualityIssues) {
            this.potentialQualityIssues = PotentialAudioQualityIssuesCopier.copy(potentialQualityIssues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder potentialQualityIssues(String ... potentialQualityIssues) {
            this.potentialQualityIssues(Arrays.asList(potentialQualityIssues));
            return this;
        }

        public AudioQualityMetricsInfo build() {
            return new AudioQualityMetricsInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioQualityMetricsInfo> {
        public Builder qualityScore(Float var1);

        public Builder potentialQualityIssues(Collection<String> var1);

        public Builder potentialQualityIssues(String ... var1);
    }
}

