/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.QueueSearchConditionListCopier;
import software.amazon.awssdk.services.connect.model.SearchableQueueType;
import software.amazon.awssdk.services.connect.model.StringCondition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueueSearchCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueueSearchCriteria> {
    private static final SdkField<List<QueueSearchCriteria>> OR_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrConditions").getter(QueueSearchCriteria.getter(QueueSearchCriteria::orConditions)).setter(QueueSearchCriteria.setter(Builder::orConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QueueSearchCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<QueueSearchCriteria>> AND_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AndConditions").getter(QueueSearchCriteria.getter(QueueSearchCriteria::andConditions)).setter(QueueSearchCriteria.setter(Builder::andConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AndConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QueueSearchCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<StringCondition> STRING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StringCondition").getter(QueueSearchCriteria.getter(QueueSearchCriteria::stringCondition)).setter(QueueSearchCriteria.setter(Builder::stringCondition)).constructor(StringCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringCondition").build()}).build();
    private static final SdkField<String> QUEUE_TYPE_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueueTypeCondition").getter(QueueSearchCriteria.getter(QueueSearchCriteria::queueTypeConditionAsString)).setter(QueueSearchCriteria.setter(Builder::queueTypeCondition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueTypeCondition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OR_CONDITIONS_FIELD, AND_CONDITIONS_FIELD, STRING_CONDITION_FIELD, QUEUE_TYPE_CONDITION_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<QueueSearchCriteria> orConditions;
    private final List<QueueSearchCriteria> andConditions;
    private final StringCondition stringCondition;
    private final String queueTypeCondition;

    private QueueSearchCriteria(BuilderImpl builder) {
        this.orConditions = builder.orConditions;
        this.andConditions = builder.andConditions;
        this.stringCondition = builder.stringCondition;
        this.queueTypeCondition = builder.queueTypeCondition;
    }

    public final boolean hasOrConditions() {
        return this.orConditions != null && !(this.orConditions instanceof SdkAutoConstructList);
    }

    public final List<QueueSearchCriteria> orConditions() {
        return this.orConditions;
    }

    public final boolean hasAndConditions() {
        return this.andConditions != null && !(this.andConditions instanceof SdkAutoConstructList);
    }

    public final List<QueueSearchCriteria> andConditions() {
        return this.andConditions;
    }

    public final StringCondition stringCondition() {
        return this.stringCondition;
    }

    public final SearchableQueueType queueTypeCondition() {
        return SearchableQueueType.fromValue(this.queueTypeCondition);
    }

    public final String queueTypeConditionAsString() {
        return this.queueTypeCondition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrConditions() ? this.orConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAndConditions() ? this.andConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stringCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueTypeConditionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueueSearchCriteria)) {
            return false;
        }
        QueueSearchCriteria other = (QueueSearchCriteria)obj;
        return this.hasOrConditions() == other.hasOrConditions() && Objects.equals(this.orConditions(), other.orConditions()) && this.hasAndConditions() == other.hasAndConditions() && Objects.equals(this.andConditions(), other.andConditions()) && Objects.equals(this.stringCondition(), other.stringCondition()) && Objects.equals(this.queueTypeConditionAsString(), other.queueTypeConditionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"QueueSearchCriteria").add("OrConditions", this.hasOrConditions() ? this.orConditions() : null).add("AndConditions", this.hasAndConditions() ? this.andConditions() : null).add("StringCondition", (Object)this.stringCondition()).add("QueueTypeCondition", (Object)this.queueTypeConditionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrConditions": {
                return Optional.ofNullable(clazz.cast(this.orConditions()));
            }
            case "AndConditions": {
                return Optional.ofNullable(clazz.cast(this.andConditions()));
            }
            case "StringCondition": {
                return Optional.ofNullable(clazz.cast(this.stringCondition()));
            }
            case "QueueTypeCondition": {
                return Optional.ofNullable(clazz.cast(this.queueTypeConditionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueueSearchCriteria, T> g) {
        return obj -> g.apply((QueueSearchCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<QueueSearchCriteria> orConditions = DefaultSdkAutoConstructList.getInstance();
        private List<QueueSearchCriteria> andConditions = DefaultSdkAutoConstructList.getInstance();
        private StringCondition stringCondition;
        private String queueTypeCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(QueueSearchCriteria model) {
            this.orConditions(model.orConditions);
            this.andConditions(model.andConditions);
            this.stringCondition(model.stringCondition);
            this.queueTypeCondition(model.queueTypeCondition);
        }

        public final List<Builder> getOrConditions() {
            List<Builder> result = QueueSearchConditionListCopier.copyToBuilder(this.orConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrConditions(Collection<BuilderImpl> orConditions) {
            this.orConditions = QueueSearchConditionListCopier.copyFromBuilder(orConditions);
        }

        @Override
        public final Builder orConditions(Collection<QueueSearchCriteria> orConditions) {
            this.orConditions = QueueSearchConditionListCopier.copy(orConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(QueueSearchCriteria ... orConditions) {
            this.orConditions(Arrays.asList(orConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(Consumer<Builder> ... orConditions) {
            this.orConditions(Stream.of(orConditions).map(c -> (QueueSearchCriteria)((Builder)QueueSearchCriteria.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getAndConditions() {
            List<Builder> result = QueueSearchConditionListCopier.copyToBuilder(this.andConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAndConditions(Collection<BuilderImpl> andConditions) {
            this.andConditions = QueueSearchConditionListCopier.copyFromBuilder(andConditions);
        }

        @Override
        public final Builder andConditions(Collection<QueueSearchCriteria> andConditions) {
            this.andConditions = QueueSearchConditionListCopier.copy(andConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(QueueSearchCriteria ... andConditions) {
            this.andConditions(Arrays.asList(andConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(Consumer<Builder> ... andConditions) {
            this.andConditions(Stream.of(andConditions).map(c -> (QueueSearchCriteria)((Builder)QueueSearchCriteria.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final StringCondition.Builder getStringCondition() {
            return this.stringCondition != null ? this.stringCondition.toBuilder() : null;
        }

        public final void setStringCondition(StringCondition.BuilderImpl stringCondition) {
            this.stringCondition = stringCondition != null ? stringCondition.build() : null;
        }

        @Override
        public final Builder stringCondition(StringCondition stringCondition) {
            this.stringCondition = stringCondition;
            return this;
        }

        public final String getQueueTypeCondition() {
            return this.queueTypeCondition;
        }

        public final void setQueueTypeCondition(String queueTypeCondition) {
            this.queueTypeCondition = queueTypeCondition;
        }

        @Override
        public final Builder queueTypeCondition(String queueTypeCondition) {
            this.queueTypeCondition = queueTypeCondition;
            return this;
        }

        @Override
        public final Builder queueTypeCondition(SearchableQueueType queueTypeCondition) {
            this.queueTypeCondition(queueTypeCondition == null ? null : queueTypeCondition.toString());
            return this;
        }

        public QueueSearchCriteria build() {
            return new QueueSearchCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueueSearchCriteria> {
        public Builder orConditions(Collection<QueueSearchCriteria> var1);

        public Builder orConditions(QueueSearchCriteria ... var1);

        public Builder orConditions(Consumer<Builder> ... var1);

        public Builder andConditions(Collection<QueueSearchCriteria> var1);

        public Builder andConditions(QueueSearchCriteria ... var1);

        public Builder andConditions(Consumer<Builder> ... var1);

        public Builder stringCondition(StringCondition var1);

        default public Builder stringCondition(Consumer<StringCondition.Builder> stringCondition) {
            return this.stringCondition((StringCondition)((StringCondition.Builder)StringCondition.builder().applyMutation(stringCondition)).build());
        }

        public Builder queueTypeCondition(String var1);

        public Builder queueTypeCondition(SearchableQueueType var1);
    }
}

