/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.PredefinedAttribute;
import software.amazon.awssdk.services.connect.model.SearchPredefinedAttributesRequest;
import software.amazon.awssdk.services.connect.model.SearchPredefinedAttributesResponse;

public class SearchPredefinedAttributesPublisher
implements SdkPublisher<SearchPredefinedAttributesResponse> {
    private final ConnectAsyncClient client;
    private final SearchPredefinedAttributesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchPredefinedAttributesPublisher(ConnectAsyncClient client, SearchPredefinedAttributesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchPredefinedAttributesPublisher(ConnectAsyncClient client, SearchPredefinedAttributesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchPredefinedAttributesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchPredefinedAttributesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PredefinedAttribute> predefinedAttributes() {
        Function<SearchPredefinedAttributesResponse, Iterator> getIterator = response -> {
            if (response != null && response.predefinedAttributes() != null) {
                return response.predefinedAttributes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchPredefinedAttributesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchPredefinedAttributesResponseFetcher
    implements AsyncPageFetcher<SearchPredefinedAttributesResponse> {
        private SearchPredefinedAttributesResponseFetcher() {
        }

        public boolean hasNextPage(SearchPredefinedAttributesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchPredefinedAttributesResponse> nextPage(SearchPredefinedAttributesResponse previousPage) {
            if (previousPage == null) {
                return SearchPredefinedAttributesPublisher.this.client.searchPredefinedAttributes(SearchPredefinedAttributesPublisher.this.firstRequest);
            }
            return SearchPredefinedAttributesPublisher.this.client.searchPredefinedAttributes((SearchPredefinedAttributesRequest)((Object)SearchPredefinedAttributesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

