/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportPhoneNumberRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, ImportPhoneNumberRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(ImportPhoneNumberRequest.getter(ImportPhoneNumberRequest::instanceId)).setter(ImportPhoneNumberRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> SOURCE_PHONE_NUMBER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourcePhoneNumberArn").getter(ImportPhoneNumberRequest.getter(ImportPhoneNumberRequest::sourcePhoneNumberArn)).setter(ImportPhoneNumberRequest.setter(Builder::sourcePhoneNumberArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePhoneNumberArn").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumberDescription").getter(ImportPhoneNumberRequest.getter(ImportPhoneNumberRequest::phoneNumberDescription)).setter(ImportPhoneNumberRequest.setter(Builder::phoneNumberDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberDescription").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(ImportPhoneNumberRequest.getter(ImportPhoneNumberRequest::tags)).setter(ImportPhoneNumberRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(ImportPhoneNumberRequest.getter(ImportPhoneNumberRequest::clientToken)).setter(ImportPhoneNumberRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, SOURCE_PHONE_NUMBER_ARN_FIELD, PHONE_NUMBER_DESCRIPTION_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));
    private final String instanceId;
    private final String sourcePhoneNumberArn;
    private final String phoneNumberDescription;
    private final Map<String, String> tags;
    private final String clientToken;

    private ImportPhoneNumberRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.sourcePhoneNumberArn = builder.sourcePhoneNumberArn;
        this.phoneNumberDescription = builder.phoneNumberDescription;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String sourcePhoneNumberArn() {
        return this.sourcePhoneNumberArn;
    }

    public final String phoneNumberDescription() {
        return this.phoneNumberDescription;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePhoneNumberArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumberDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportPhoneNumberRequest)) {
            return false;
        }
        ImportPhoneNumberRequest other = (ImportPhoneNumberRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.sourcePhoneNumberArn(), other.sourcePhoneNumberArn()) && Objects.equals(this.phoneNumberDescription(), other.phoneNumberDescription()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"ImportPhoneNumberRequest").add("InstanceId", (Object)this.instanceId()).add("SourcePhoneNumberArn", (Object)this.sourcePhoneNumberArn()).add("PhoneNumberDescription", (Object)this.phoneNumberDescription()).add("Tags", this.hasTags() ? this.tags() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "SourcePhoneNumberArn": {
                return Optional.ofNullable(clazz.cast(this.sourcePhoneNumberArn()));
            }
            case "PhoneNumberDescription": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberDescription()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportPhoneNumberRequest, T> g) {
        return obj -> g.apply((ImportPhoneNumberRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String sourcePhoneNumberArn;
        private String phoneNumberDescription;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportPhoneNumberRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.sourcePhoneNumberArn(model.sourcePhoneNumberArn);
            this.phoneNumberDescription(model.phoneNumberDescription);
            this.tags(model.tags);
            this.clientToken(model.clientToken);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getSourcePhoneNumberArn() {
            return this.sourcePhoneNumberArn;
        }

        public final void setSourcePhoneNumberArn(String sourcePhoneNumberArn) {
            this.sourcePhoneNumberArn = sourcePhoneNumberArn;
        }

        @Override
        public final Builder sourcePhoneNumberArn(String sourcePhoneNumberArn) {
            this.sourcePhoneNumberArn = sourcePhoneNumberArn;
            return this;
        }

        public final String getPhoneNumberDescription() {
            return this.phoneNumberDescription;
        }

        public final void setPhoneNumberDescription(String phoneNumberDescription) {
            this.phoneNumberDescription = phoneNumberDescription;
        }

        @Override
        public final Builder phoneNumberDescription(String phoneNumberDescription) {
            this.phoneNumberDescription = phoneNumberDescription;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportPhoneNumberRequest build() {
            return new ImportPhoneNumberRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportPhoneNumberRequest> {
        public Builder instanceId(String var1);

        public Builder sourcePhoneNumberArn(String var1);

        public Builder phoneNumberDescription(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

