/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.FlowAssociationSummary;
import software.amazon.awssdk.services.connect.model.ListFlowAssociationsRequest;
import software.amazon.awssdk.services.connect.model.ListFlowAssociationsResponse;

public class ListFlowAssociationsIterable
implements SdkIterable<ListFlowAssociationsResponse> {
    private final ConnectClient client;
    private final ListFlowAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFlowAssociationsIterable(ConnectClient client, ListFlowAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFlowAssociationsResponseFetcher();
    }

    public Iterator<ListFlowAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FlowAssociationSummary> flowAssociationSummaryList() {
        Function<ListFlowAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.flowAssociationSummaryList() != null) {
                return response.flowAssociationSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFlowAssociationsResponseFetcher
    implements SyncPageFetcher<ListFlowAssociationsResponse> {
        private ListFlowAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListFlowAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFlowAssociationsResponse nextPage(ListFlowAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListFlowAssociationsIterable.this.client.listFlowAssociations(ListFlowAssociationsIterable.this.firstRequest);
            }
            return ListFlowAssociationsIterable.this.client.listFlowAssociations((ListFlowAssociationsRequest)((Object)ListFlowAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

