/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TargetListType {
    PROFICIENCIES("PROFICIENCIES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TargetListType> VALUE_MAP;
    private final String value;

    private TargetListType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TargetListType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TargetListType> knownValues() {
        EnumSet<TargetListType> knownValues = EnumSet.allOf(TargetListType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TargetListType.class, TargetListType::toString);
    }
}

