/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.Distribution;
import software.amazon.awssdk.services.connect.model.DistributionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AgentConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AgentConfig> {
    private static final SdkField<List<Distribution>> DISTRIBUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Distributions").getter(AgentConfig.getter(AgentConfig::distributions)).setter(AgentConfig.setter(Builder::distributions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distributions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Distribution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Distribution> distributions;

    private AgentConfig(BuilderImpl builder) {
        this.distributions = builder.distributions;
    }

    public final boolean hasDistributions() {
        return this.distributions != null && !(this.distributions instanceof SdkAutoConstructList);
    }

    public final List<Distribution> distributions() {
        return this.distributions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDistributions() ? this.distributions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentConfig)) {
            return false;
        }
        AgentConfig other = (AgentConfig)obj;
        return this.hasDistributions() == other.hasDistributions() && Objects.equals(this.distributions(), other.distributions());
    }

    public final String toString() {
        return ToString.builder((String)"AgentConfig").add("Distributions", this.hasDistributions() ? this.distributions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Distributions": {
                return Optional.ofNullable(clazz.cast(this.distributions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentConfig, T> g) {
        return obj -> g.apply((AgentConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Distribution> distributions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AgentConfig model) {
            this.distributions(model.distributions);
        }

        public final List<Distribution.Builder> getDistributions() {
            List<Distribution.Builder> result = DistributionListCopier.copyToBuilder(this.distributions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDistributions(Collection<Distribution.BuilderImpl> distributions) {
            this.distributions = DistributionListCopier.copyFromBuilder(distributions);
        }

        @Override
        public final Builder distributions(Collection<Distribution> distributions) {
            this.distributions = DistributionListCopier.copy(distributions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder distributions(Distribution ... distributions) {
            this.distributions(Arrays.asList(distributions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder distributions(Consumer<Distribution.Builder> ... distributions) {
            this.distributions(Stream.of(distributions).map(c -> (Distribution)((Distribution.Builder)Distribution.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AgentConfig build() {
            return new AgentConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AgentConfig> {
        public Builder distributions(Collection<Distribution> var1);

        public Builder distributions(Distribution ... var1);

        public Builder distributions(Consumer<Distribution.Builder> ... var1);
    }
}

