/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.EvaluationFormSummary;
import software.amazon.awssdk.services.connect.model.ListEvaluationFormsRequest;
import software.amazon.awssdk.services.connect.model.ListEvaluationFormsResponse;

public class ListEvaluationFormsPublisher
implements SdkPublisher<ListEvaluationFormsResponse> {
    private final ConnectAsyncClient client;
    private final ListEvaluationFormsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEvaluationFormsPublisher(ConnectAsyncClient client, ListEvaluationFormsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEvaluationFormsPublisher(ConnectAsyncClient client, ListEvaluationFormsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEvaluationFormsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEvaluationFormsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EvaluationFormSummary> evaluationFormSummaryList() {
        Function<ListEvaluationFormsResponse, Iterator> getIterator = response -> {
            if (response != null && response.evaluationFormSummaryList() != null) {
                return response.evaluationFormSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEvaluationFormsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEvaluationFormsResponseFetcher
    implements AsyncPageFetcher<ListEvaluationFormsResponse> {
        private ListEvaluationFormsResponseFetcher() {
        }

        public boolean hasNextPage(ListEvaluationFormsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEvaluationFormsResponse> nextPage(ListEvaluationFormsResponse previousPage) {
            if (previousPage == null) {
                return ListEvaluationFormsPublisher.this.client.listEvaluationForms(ListEvaluationFormsPublisher.this.firstRequest);
            }
            return ListEvaluationFormsPublisher.this.client.listEvaluationForms((ListEvaluationFormsRequest)((Object)ListEvaluationFormsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

