/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.SearchVocabulariesRequest;
import software.amazon.awssdk.services.connect.model.SearchVocabulariesResponse;
import software.amazon.awssdk.services.connect.model.VocabularySummary;

public class SearchVocabulariesPublisher
implements SdkPublisher<SearchVocabulariesResponse> {
    private final ConnectAsyncClient client;
    private final SearchVocabulariesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchVocabulariesPublisher(ConnectAsyncClient client, SearchVocabulariesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchVocabulariesPublisher(ConnectAsyncClient client, SearchVocabulariesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchVocabulariesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchVocabulariesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VocabularySummary> vocabularySummaryList() {
        Function<SearchVocabulariesResponse, Iterator> getIterator = response -> {
            if (response != null && response.vocabularySummaryList() != null) {
                return response.vocabularySummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchVocabulariesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchVocabulariesResponseFetcher
    implements AsyncPageFetcher<SearchVocabulariesResponse> {
        private SearchVocabulariesResponseFetcher() {
        }

        public boolean hasNextPage(SearchVocabulariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchVocabulariesResponse> nextPage(SearchVocabulariesResponse previousPage) {
            if (previousPage == null) {
                return SearchVocabulariesPublisher.this.client.searchVocabularies(SearchVocabulariesPublisher.this.firstRequest);
            }
            return SearchVocabulariesPublisher.this.client.searchVocabularies((SearchVocabulariesRequest)((Object)SearchVocabulariesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

