/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ViewType {
    CUSTOMER_MANAGED("CUSTOMER_MANAGED"),
    AWS_MANAGED("AWS_MANAGED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ViewType> VALUE_MAP;
    private final String value;

    private ViewType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ViewType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ViewType> knownValues() {
        EnumSet<ViewType> knownValues = EnumSet.allOf(ViewType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ViewType.class, ViewType::toString);
    }
}

