/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserProficiency
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserProficiency> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeName").getter(UserProficiency.getter(UserProficiency::attributeName)).setter(UserProficiency.setter(Builder::attributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()}).build();
    private static final SdkField<String> ATTRIBUTE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeValue").getter(UserProficiency.getter(UserProficiency::attributeValue)).setter(UserProficiency.setter(Builder::attributeValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeValue").build()}).build();
    private static final SdkField<Float> LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Level").getter(UserProficiency.getter(UserProficiency::level)).setter(UserProficiency.setter(Builder::level)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Level").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD, ATTRIBUTE_VALUE_FIELD, LEVEL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String attributeName;
    private final String attributeValue;
    private final Float level;

    private UserProficiency(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.attributeValue = builder.attributeValue;
        this.level = builder.level;
    }

    public final String attributeName() {
        return this.attributeName;
    }

    public final String attributeValue() {
        return this.attributeValue;
    }

    public final Float level() {
        return this.level;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.level());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserProficiency)) {
            return false;
        }
        UserProficiency other = (UserProficiency)obj;
        return Objects.equals(this.attributeName(), other.attributeName()) && Objects.equals(this.attributeValue(), other.attributeValue()) && Objects.equals(this.level(), other.level());
    }

    public final String toString() {
        return ToString.builder((String)"UserProficiency").add("AttributeName", (Object)this.attributeName()).add("AttributeValue", (Object)this.attributeValue()).add("Level", (Object)this.level()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
            case "AttributeValue": {
                return Optional.ofNullable(clazz.cast(this.attributeValue()));
            }
            case "Level": {
                return Optional.ofNullable(clazz.cast(this.level()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserProficiency, T> g) {
        return obj -> g.apply((UserProficiency)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attributeName;
        private String attributeValue;
        private Float level;

        private BuilderImpl() {
        }

        private BuilderImpl(UserProficiency model) {
            this.attributeName(model.attributeName);
            this.attributeValue(model.attributeValue);
            this.level(model.level);
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final String getAttributeValue() {
            return this.attributeValue;
        }

        public final void setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        @Override
        public final Builder attributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
            return this;
        }

        public final Float getLevel() {
            return this.level;
        }

        public final void setLevel(Float level) {
            this.level = level;
        }

        @Override
        public final Builder level(Float level) {
            this.level = level;
            return this;
        }

        public UserProficiency build() {
            return new UserProficiency(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserProficiency> {
        public Builder attributeName(String var1);

        public Builder attributeValue(String var1);

        public Builder level(Float var1);
    }
}

